/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnd;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.privatekey.Pkcs8PbeType;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.dnd.DragEntry;

public class DragKeyPairEntry
extends DragEntry {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dnd/resources");
    private static final String EXTENSION = "p12";
    private byte[] contentBytes;
    private String contentStr;
    private ImageIcon image;

    public DragKeyPairEntry(String name, PrivateKey privateKey, Password password, Certificate[] certificateChain) throws CryptoException {
        super(name);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            KeyStore p12 = KeyStoreUtil.create(KeyStoreType.PKCS12);
            p12.setKeyEntry(name, privateKey, password.toCharArray(), certificateChain);
            p12.store(baos, password.toCharArray());
            this.contentBytes = baos.toByteArray();
            StringBuilder sbContent = new StringBuilder();
            String pkcs8 = Pkcs8Util.getEncryptedPem(privateKey, Pkcs8PbeType.SHA1_128BIT_RC4, password);
            String pkcs7 = X509CertUtil.getCertsEncodedPkcs7Pem(X509CertUtil.convertCertificates(certificateChain));
            sbContent.append(res.getString("DragKeyPairEntry.StringFlavor.PrivateKeyPart.text"));
            sbContent.append("\n\n");
            sbContent.append(pkcs8);
            sbContent.append('\n');
            sbContent.append(res.getString("DragKeyPairEntry.StringFlavor.CertificateChainPart.text"));
            sbContent.append("\n\n");
            sbContent.append(pkcs7);
            this.contentStr = sbContent.toString();
            this.image = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/drag_keypair.png")));
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoGetKeyPairEntryContent.exception.message"), ex);
        }
    }

    @Override
    public ImageIcon getImage() {
        return this.image;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public byte[] getContent() {
        return this.contentBytes;
    }

    @Override
    public String getContentString() {
        return this.contentStr;
    }
}

