/*
 * Decompiled with CFR 0.152.
 */
package org.kse;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.kse.AuthorityCertificates;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.gui.KeyStoreTableColumns;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.StringUtils;
import org.kse.utilities.net.ManualProxySelector;
import org.kse.utilities.net.NoProxySelector;
import org.kse.utilities.net.PacProxySelector;
import org.kse.utilities.net.ProxyAddress;
import org.kse.utilities.net.ProxyConfigurationType;
import org.kse.utilities.net.SystemProxySelector;

public class ApplicationSettings {
    public static final String SYSTEM_LANGUAGE = "system";
    private static final String PREFS_NODE = "/org/kse";
    private static final String PREFS_NODE_OLD = "/net/sf/keystore_explorer";
    private static final String KSE3_DEFAULTDN = "kse3.defaultdn";
    private static final String KSE3_SSLHOSTS = "kse3.sslhosts";
    private static final String KSE3_SSLPORTS = "kse3.sslports";
    private static final String KSE3_TIPINDEX = "kse3.tipindex";
    private static final String KSE3_TIPSONSTARTUP = "kse3.tipsonstartup";
    private static final String KSE3_LICENSEAGREED = "kse3.licenseagreed";
    private static final String KSE3_LOOKFEEL = "kse3.lookfeel";
    private static final String KSE3_LOOKFEELDECOR = "kse3.lookfeeldecor";
    private static final String KSE3_CURRENTDIR = "kse3.currentdir";
    private static final String KSE3_RECENTFILE = "kse3.recentfile";
    private static final String KSE3_TABLAYOUT = "kse3.tablayout";
    private static final String KSE3_SHOWSTATUSBAR = "kse3.showstatusbar";
    private static final String KSE3_SHOWTOOLBAR = "kse3.showtoolbar";
    private static final String KSE3_WIDTH = "kse3.width";
    private static final String KSE3_HEIGHT = "kse3.height";
    private static final String KSE3_YPOS = "kse3.ypos";
    private static final String KSE3_XPOS = "kse3.xpos";
    private static final String KSE3_PROXY = "kse3.proxy";
    private static final String KSE3_SOCKSPORT = "kse3.socksport";
    private static final String KSE3_SOCKSHOST = "kse3.sockshost";
    private static final String KSE3_HTTPSPORT = "kse3.httpsport";
    private static final String KSE3_HTTPSHOST = "kse3.httpshost";
    private static final String KSE3_HTTPPORT = "kse3.httpport";
    private static final String KSE3_HTTPHOST = "kse3.httphost";
    private static final String KSE3_PACURL = "kse3.pacurl";
    private static final String KSE3_MINPWDQUALENFORCE = "kse3.minpwdqualenforce";
    private static final String KSE3_MINPWDQUAL = "kse3.minpwdqual";
    private static final String KSE3_PWDQUALENABLE = "kse3.pwdqualenable";
    private static final String KSE3_CERTFINGERTYPE = "kse3.certfingertype";
    private static final String KSE3_SECKEYSIZE = "kse3.seckeysize";
    private static final String KSE3_SECKEYTYPE = "kse3.seckeytype";
    private static final String KSE3_KEYPAIRSIZE = "kse3.keypairsize";
    private static final String KSE3_KEYPAIRTYPE = "kse3.keypairtype";
    private static final String KSE3_ENABLEIMPORTCAREPLYTRUSTCHECK = "kse3.enableimportcareplytrustcheck";
    private static final String KSE3_ENABLEIMPORTTRUSTEDCERTTRUSTCHECK = "kse3.enableimporttrustedcerttrustcheck";
    private static final String KSE3_USEWINTRUSTROOTCERTS = "kse3.usewintrustrootcerts";
    private static final String KSE3_CACERTSFILE = "kse3.cacertsfile";
    private static final String KSE3_USECACERTS = "kse3.usecacerts";
    private static final String KSE3_AUTO_UPDATE_CHECK_ENABLED = "kse3.autoupdatecheckenabled";
    private static final String KSE3_AUTO_UPDATE_CHECK_LAST_CHECK = "kse3.autoupdatechecklastcheck";
    private static final String KSE3_AUTO_UPDATE_CHECK_INTERVAL = "kse3.autoupdatecheckinterval";
    private static final String KSE3_PKCS11_LIBS = "kse3.pkcs11libs";
    private static final String KSE3_LANGUAGE = "kse3.locale";
    private static final String KSE3_EXPIRY_WARN_DAYS = "kse3.expirywarndays";
    private static final String KSE3_COLUMNS = "kse3.columns";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ApplicationSettings applicationSettings;
    private boolean useCaCertificates;
    private File caCertificatesFile;
    private boolean useWindowsTrustedRootCertificates;
    private boolean enableImportTrustedCertTrustCheck;
    private boolean enableImportCaReplyTrustCheck;
    private KeyPairType generateKeyPairType;
    private int generateKeyPairSize;
    private SecretKeyType generateSecretKeyType;
    private int generateSecretKeySize;
    private DigestType certificateFingerprintType;
    private PasswordQualityConfig passwordQualityConfig;
    private Rectangle sizeAndPosition;
    private boolean showToolBar;
    private boolean showStatusBar;
    private int tabLayout;
    private File[] recentFiles;
    private File currentDirectory;
    private String lookAndFeelClass;
    private boolean lookAndFeelDecorated;
    private boolean licenseAgreed;
    private boolean showTipsOnStartUp;
    private int nextTipIndex;
    private String defaultDN;
    private String sslHosts;
    private String sslPorts;
    private boolean autoUpdateCheckEnabled;
    private Date autoUpdateCheckLastCheck;
    private int autoUpdateCheckInterval;
    private String p11Libs;
    private String language;
    private KeyStoreTableColumns kstColumns = new KeyStoreTableColumns();
    private int expiryWarnDays;

    private ApplicationSettings() {
        Preferences root = Preferences.userRoot();
        try {
            if (root.nodeExists(PREFS_NODE_OLD) && !root.nodeExists(PREFS_NODE)) {
                Preferences prefsOld = root.node(PREFS_NODE_OLD);
                Preferences prefsNew = root.node(PREFS_NODE);
                for (String key : prefsOld.keys()) {
                    prefsNew.put(key, prefsOld.get(key, ""));
                }
                prefsNew.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.load();
    }

    public static synchronized ApplicationSettings getInstance() {
        if (applicationSettings == null) {
            applicationSettings = new ApplicationSettings();
        }
        return applicationSettings;
    }

    public void load() {
        String recentFile;
        Preferences preferences = this.getUnderlyingPreferences();
        this.useCaCertificates = preferences.getBoolean(KSE3_USECACERTS, false);
        String cacertsPath = preferences.get(KSE3_CACERTSFILE, AuthorityCertificates.getDefaultCaCertificatesLocation().toString());
        this.caCertificatesFile = this.cleanFilePath(new File(cacertsPath));
        this.useWindowsTrustedRootCertificates = preferences.getBoolean(KSE3_USEWINTRUSTROOTCERTS, false);
        this.enableImportTrustedCertTrustCheck = preferences.getBoolean(KSE3_ENABLEIMPORTTRUSTEDCERTTRUSTCHECK, false);
        this.enableImportCaReplyTrustCheck = preferences.getBoolean(KSE3_ENABLEIMPORTCAREPLYTRUSTCHECK, false);
        this.generateKeyPairType = KeyPairType.resolveJce(preferences.get(KSE3_KEYPAIRTYPE, KeyPairType.RSA.jce()));
        if (this.generateKeyPairType == null) {
            this.generateKeyPairType = KeyPairType.RSA;
        }
        int defaultKeyPairSize = this.generateKeyPairType == KeyPairType.RSA ? 2048 : 1024;
        this.generateKeyPairSize = preferences.getInt(KSE3_KEYPAIRSIZE, defaultKeyPairSize);
        this.generateSecretKeyType = SecretKeyType.resolveJce(preferences.get(KSE3_SECKEYTYPE, SecretKeyType.AES.jce()));
        if (this.generateSecretKeyType == null) {
            this.generateSecretKeyType = SecretKeyType.AES;
        }
        this.generateSecretKeySize = preferences.getInt(KSE3_SECKEYSIZE, 192);
        this.certificateFingerprintType = DigestType.resolveJce(preferences.get(KSE3_CERTFINGERTYPE, DigestType.SHA1.jce()));
        if (this.certificateFingerprintType == null) {
            this.certificateFingerprintType = DigestType.SHA1;
        }
        this.passwordQualityConfig = new PasswordQualityConfig(preferences.getBoolean(KSE3_PWDQUALENABLE, false), preferences.getBoolean(KSE3_MINPWDQUALENFORCE, false), preferences.getInt(KSE3_MINPWDQUAL, 60));
        ProxyConfigurationType proxyConfigurationType = ProxyConfigurationType.resolve(preferences.get(KSE3_PROXY, ProxyConfigurationType.SYSTEM.name()));
        SystemProxySelector.setSystemProxySelector(ProxySelector.getDefault());
        switch (proxyConfigurationType) {
            case NONE: {
                ProxySelector.setDefault(new NoProxySelector());
                break;
            }
            case PAC: {
                String pacUrl = preferences.get(KSE3_PACURL, null);
                if (pacUrl != null) {
                    ProxySelector.setDefault(new PacProxySelector(pacUrl));
                    break;
                }
                ProxySelector.setDefault(new NoProxySelector());
                break;
            }
            case MANUAL: {
                ProxyAddress httpProxyAddress = null;
                ProxyAddress httpsProxyAddress = null;
                ProxyAddress socksProxyAddress = null;
                String httpHost = preferences.get(KSE3_HTTPHOST, null);
                int httpPort = preferences.getInt(KSE3_HTTPPORT, 0);
                if (httpHost != null && httpPort > 0) {
                    httpProxyAddress = new ProxyAddress(httpHost, httpPort);
                }
                String httpsHost = preferences.get(KSE3_HTTPSHOST, null);
                int httpsPort = preferences.getInt(KSE3_HTTPSPORT, 0);
                if (httpsHost != null && httpsPort > 0) {
                    httpsProxyAddress = new ProxyAddress(httpsHost, httpsPort);
                }
                String socksHost = preferences.get(KSE3_SOCKSHOST, null);
                int socksPort = preferences.getInt(KSE3_SOCKSPORT, 0);
                if (socksHost != null && socksPort > 0) {
                    socksProxyAddress = new ProxyAddress(socksHost, socksPort);
                }
                if (httpProxyAddress != null || httpsProxyAddress != null) {
                    ProxySelector.setDefault(new ManualProxySelector(httpProxyAddress, httpsProxyAddress, null, socksProxyAddress));
                    break;
                }
                ProxySelector.setDefault(new NoProxySelector());
                break;
            }
            default: {
                ProxySelector.setDefault(new SystemProxySelector());
            }
        }
        this.sizeAndPosition = new Rectangle(preferences.getInt(KSE3_XPOS, 0), preferences.getInt(KSE3_YPOS, 0), preferences.getInt(KSE3_WIDTH, 700), preferences.getInt(KSE3_HEIGHT, 450));
        this.showToolBar = preferences.getBoolean(KSE3_SHOWTOOLBAR, true);
        this.showStatusBar = preferences.getBoolean(KSE3_SHOWSTATUSBAR, true);
        this.tabLayout = preferences.getInt(KSE3_TABLAYOUT, 0);
        ArrayList<File> recentFilesList = new ArrayList<File>();
        for (int i = 1; i <= 6 && (recentFile = preferences.get(KSE3_RECENTFILE + i, null)) != null; ++i) {
            recentFilesList.add(this.cleanFilePath(new File(recentFile)));
        }
        this.recentFiles = recentFilesList.toArray(new File[recentFilesList.size()]);
        String currentDirectoryStr = preferences.get(KSE3_CURRENTDIR, null);
        if (currentDirectoryStr != null) {
            this.currentDirectory = this.cleanFilePath(new File(currentDirectoryStr));
        }
        this.lookAndFeelClass = preferences.get(KSE3_LOOKFEEL, null);
        this.lookAndFeelDecorated = preferences.getBoolean(KSE3_LOOKFEELDECOR, false);
        this.licenseAgreed = preferences.getBoolean(KSE3_LICENSEAGREED, false);
        this.showTipsOnStartUp = preferences.getBoolean(KSE3_TIPSONSTARTUP, true);
        this.nextTipIndex = preferences.getInt(KSE3_TIPINDEX, 0);
        this.defaultDN = preferences.get(KSE3_DEFAULTDN, "");
        this.sslHosts = preferences.get(KSE3_SSLHOSTS, "www.google.com;www.amazon.com");
        this.sslPorts = preferences.get(KSE3_SSLPORTS, "443");
        this.autoUpdateCheckEnabled = preferences.getBoolean(KSE3_AUTO_UPDATE_CHECK_ENABLED, true);
        this.autoUpdateCheckInterval = preferences.getInt(KSE3_AUTO_UPDATE_CHECK_INTERVAL, 14);
        this.autoUpdateCheckLastCheck = this.getDate(preferences, KSE3_AUTO_UPDATE_CHECK_LAST_CHECK, new Date());
        this.p11Libs = preferences.get(KSE3_PKCS11_LIBS, "");
        this.language = preferences.get(KSE3_LANGUAGE, SYSTEM_LANGUAGE);
        this.kstColumns.setColumns(preferences.getInt(KSE3_COLUMNS, 31));
        this.expiryWarnDays = preferences.getInt(KSE3_EXPIRY_WARN_DAYS, 0);
        this.kstColumns.setExpiryWarnDays(this.expiryWarnDays);
    }

    private File cleanFilePath(File filePath) {
        try {
            return filePath.getCanonicalFile();
        }
        catch (IOException e) {
            return filePath;
        }
    }

    private Date getDate(Preferences preferences, String name, Date def) {
        try {
            return this.dateFormat.parse(preferences.get(name, this.dateFormat.format(def)));
        }
        catch (ParseException e) {
            return def;
        }
    }

    public void save() {
        Preferences preferences = this.getUnderlyingPreferences();
        preferences.putBoolean(KSE3_USECACERTS, this.useCaCertificates);
        preferences.put(KSE3_CACERTSFILE, this.caCertificatesFile.toString());
        preferences.putBoolean(KSE3_USEWINTRUSTROOTCERTS, this.useWindowsTrustedRootCertificates);
        preferences.putBoolean(KSE3_ENABLEIMPORTTRUSTEDCERTTRUSTCHECK, this.enableImportTrustedCertTrustCheck);
        preferences.putBoolean(KSE3_ENABLEIMPORTCAREPLYTRUSTCHECK, this.enableImportCaReplyTrustCheck);
        preferences.put(KSE3_KEYPAIRTYPE, this.generateKeyPairType.jce());
        preferences.putInt(KSE3_KEYPAIRSIZE, this.generateKeyPairSize);
        preferences.put(KSE3_SECKEYTYPE, this.generateSecretKeyType.jce());
        preferences.putInt(KSE3_SECKEYSIZE, this.generateSecretKeySize);
        preferences.put(KSE3_CERTFINGERTYPE, this.certificateFingerprintType.jce());
        preferences.putBoolean(KSE3_PWDQUALENABLE, this.passwordQualityConfig.getEnabled());
        preferences.putBoolean(KSE3_MINPWDQUALENFORCE, this.passwordQualityConfig.getEnforced());
        preferences.putInt(KSE3_MINPWDQUAL, this.passwordQualityConfig.getMinimumQuality());
        this.getCurrentProxySettings(preferences);
        preferences.putInt(KSE3_XPOS, this.sizeAndPosition.x);
        preferences.putInt(KSE3_YPOS, this.sizeAndPosition.y);
        preferences.putInt(KSE3_WIDTH, this.sizeAndPosition.width);
        preferences.putInt(KSE3_HEIGHT, this.sizeAndPosition.height);
        preferences.putBoolean(KSE3_SHOWTOOLBAR, this.showToolBar);
        preferences.putBoolean(KSE3_SHOWSTATUSBAR, this.showStatusBar);
        preferences.putInt(KSE3_TABLAYOUT, this.tabLayout);
        this.clearExistingRecentFiles(preferences);
        for (int i = 1; i <= this.recentFiles.length; ++i) {
            preferences.put(KSE3_RECENTFILE + i, this.recentFiles[i - 1].toString());
        }
        preferences.put(KSE3_CURRENTDIR, this.currentDirectory.toString());
        preferences.put(KSE3_LOOKFEEL, this.lookAndFeelClass);
        preferences.putBoolean(KSE3_LOOKFEELDECOR, this.lookAndFeelDecorated);
        preferences.putBoolean(KSE3_LICENSEAGREED, this.licenseAgreed);
        preferences.putBoolean(KSE3_TIPSONSTARTUP, this.showTipsOnStartUp);
        preferences.putInt(KSE3_TIPINDEX, this.nextTipIndex);
        preferences.put(KSE3_DEFAULTDN, this.defaultDN);
        preferences.put(KSE3_SSLHOSTS, this.getSslHosts());
        preferences.put(KSE3_SSLPORTS, this.getSslPorts());
        preferences.putBoolean(KSE3_AUTO_UPDATE_CHECK_ENABLED, this.isAutoUpdateCheckEnabled());
        preferences.putInt(KSE3_AUTO_UPDATE_CHECK_INTERVAL, this.getAutoUpdateCheckInterval());
        preferences.put(KSE3_AUTO_UPDATE_CHECK_LAST_CHECK, this.dateFormat.format(this.getAutoUpdateCheckLastCheck()));
        preferences.put(KSE3_PKCS11_LIBS, this.getP11Libs());
        preferences.put(KSE3_LANGUAGE, this.language);
        preferences.putInt(KSE3_COLUMNS, this.kstColumns.getColumns());
        preferences.putInt(KSE3_EXPIRY_WARN_DAYS, this.kstColumns.getExpiryWarnDays());
    }

    private void clearExistingRecentFiles(Preferences preferences) {
        String recentFile;
        for (int i = 1; i <= 6 && (recentFile = preferences.get(KSE3_RECENTFILE + i, null)) != null; ++i) {
            preferences.remove(KSE3_RECENTFILE + i);
        }
    }

    private void getCurrentProxySettings(Preferences preferences) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector instanceof NoProxySelector) {
            preferences.put(KSE3_PROXY, ProxyConfigurationType.NONE.name());
        } else if (proxySelector instanceof SystemProxySelector) {
            preferences.put(KSE3_PROXY, ProxyConfigurationType.SYSTEM.name());
        } else if (proxySelector instanceof PacProxySelector) {
            PacProxySelector pacProxySelector = (PacProxySelector)proxySelector;
            preferences.put(KSE3_PACURL, pacProxySelector.getPacUrl());
            preferences.put(KSE3_PROXY, ProxyConfigurationType.PAC.name());
        } else if (proxySelector instanceof ManualProxySelector) {
            ProxyAddress socksProxyAddress;
            ProxyAddress httpsProxyAddress;
            ManualProxySelector manualProxySelector = (ManualProxySelector)proxySelector;
            ProxyAddress httpProxyAddress = manualProxySelector.getHttpProxyAddress();
            if (httpProxyAddress != null) {
                preferences.put(KSE3_HTTPHOST, httpProxyAddress.getHost());
                preferences.putInt(KSE3_HTTPPORT, httpProxyAddress.getPort());
            }
            if ((httpsProxyAddress = manualProxySelector.getHttpsProxyAddress()) != null) {
                preferences.put(KSE3_HTTPSHOST, httpsProxyAddress.getHost());
                preferences.putInt(KSE3_HTTPSPORT, httpsProxyAddress.getPort());
            }
            if ((socksProxyAddress = manualProxySelector.getSocksProxyAddress()) != null) {
                preferences.put(KSE3_SOCKSHOST, socksProxyAddress.getHost());
                preferences.putInt(KSE3_SOCKSPORT, socksProxyAddress.getPort());
            }
            preferences.put(KSE3_PROXY, ProxyConfigurationType.MANUAL.name());
        }
    }

    public void clear() throws BackingStoreException {
        Preferences preferences = this.getUnderlyingPreferences();
        preferences.clear();
    }

    private Preferences getUnderlyingPreferences() {
        return Preferences.userRoot().node(PREFS_NODE);
    }

    public void addSslPort(String newSslPort) {
        String newSslPorts = StringUtils.addToList(newSslPort, this.getSslPorts(), 10);
        this.setSslPorts(newSslPorts);
    }

    public void addSslHost(String newSslHost) {
        String newSslHosts = StringUtils.addToList(newSslHost, this.getSslHosts(), 10);
        this.setSslHosts(newSslHosts);
    }

    public void addP11Lib(String p11Lib) {
        String newP11Libs = StringUtils.addToList(p11Lib, this.getP11Libs(), 10);
        this.setP11Libs(newP11Libs);
    }

    public boolean getUseCaCertificates() {
        return this.useCaCertificates;
    }

    public void setUseCaCertificates(boolean useCaCertificates) {
        this.useCaCertificates = useCaCertificates;
    }

    public File getCaCertificatesFile() {
        return this.caCertificatesFile;
    }

    public void setCaCertificatesFile(File caCertificatesFile) {
        this.caCertificatesFile = caCertificatesFile;
    }

    public boolean getUseWindowsTrustedRootCertificates() {
        return this.useWindowsTrustedRootCertificates;
    }

    public void setUseWindowsTrustedRootCertificates(boolean useWindowsTrustedRootCertificates) {
        this.useWindowsTrustedRootCertificates = useWindowsTrustedRootCertificates;
    }

    public boolean getEnableImportTrustedCertTrustCheck() {
        return this.enableImportTrustedCertTrustCheck;
    }

    public void setEnableImportTrustedCertTrustCheck(boolean enableImportTrustedCertTrustCheck) {
        this.enableImportTrustedCertTrustCheck = enableImportTrustedCertTrustCheck;
    }

    public boolean getEnableImportCaReplyTrustCheck() {
        return this.enableImportCaReplyTrustCheck;
    }

    public void setEnableImportCaReplyTrustCheck(boolean enableImportCaReplyTrustCheck) {
        this.enableImportCaReplyTrustCheck = enableImportCaReplyTrustCheck;
    }

    public KeyPairType getGenerateKeyPairType() {
        return this.generateKeyPairType;
    }

    public void setGenerateKeyPairType(KeyPairType generateKeyPairType) {
        this.generateKeyPairType = generateKeyPairType;
    }

    public int getGenerateKeyPairSize() {
        return this.generateKeyPairSize;
    }

    public void setGenerateKeyPairSize(int generateKeyPairSize) {
        this.generateKeyPairSize = generateKeyPairSize;
    }

    public SecretKeyType getGenerateSecretKeyType() {
        return this.generateSecretKeyType;
    }

    public void setGenerateSecretKeyType(SecretKeyType generateSecretKeyType) {
        this.generateSecretKeyType = generateSecretKeyType;
    }

    public int getGenerateSecretKeySize() {
        return this.generateSecretKeySize;
    }

    public void setGenerateSecretKeySize(int generateSecretKeySize) {
        this.generateSecretKeySize = generateSecretKeySize;
    }

    public DigestType getCertificateFingerprintType() {
        return this.certificateFingerprintType;
    }

    public void setCertificateFingerprintType(DigestType certificateFingerprintType) {
        this.certificateFingerprintType = certificateFingerprintType;
    }

    public PasswordQualityConfig getPasswordQualityConfig() {
        return this.passwordQualityConfig;
    }

    public void setPasswordQualityConfig(PasswordQualityConfig passwordQualityConfig) {
        this.passwordQualityConfig = passwordQualityConfig;
    }

    public Rectangle getSizeAndPosition() {
        return this.sizeAndPosition;
    }

    public void setSizeAndPosition(Rectangle sizeAndPosition) {
        this.sizeAndPosition = sizeAndPosition;
    }

    public boolean getShowToolBar() {
        return this.showToolBar;
    }

    public void setShowToolBar(boolean showToolBar) {
        this.showToolBar = showToolBar;
    }

    public boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public void setShowStatusBar(boolean showStatusBar) {
        this.showStatusBar = showStatusBar;
    }

    public int getTabLayout() {
        return this.tabLayout;
    }

    public void setTabLayout(int tabLayout) {
        this.tabLayout = tabLayout;
    }

    public File[] getRecentFiles() {
        return this.recentFiles;
    }

    public void setRecentFiles(File[] recentFiles) {
        this.recentFiles = recentFiles;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public String getLookAndFeelClass() {
        return this.lookAndFeelClass;
    }

    public void setLookAndFeelClass(String lookAndFeelClass) {
        this.lookAndFeelClass = lookAndFeelClass;
    }

    public boolean getLookAndFeelDecorated() {
        return this.lookAndFeelDecorated;
    }

    public void setLookAndFeelDecorated(boolean lookAndFeelDecorated) {
        this.lookAndFeelDecorated = lookAndFeelDecorated;
    }

    public boolean getShowTipsOnStartUp() {
        return this.showTipsOnStartUp;
    }

    public void setShowTipsOnStartUp(boolean showTipsOnStartUp) {
        this.showTipsOnStartUp = showTipsOnStartUp;
    }

    public int getNextTipIndex() {
        return this.nextTipIndex;
    }

    public void setNextTipIndex(int nextTipIndex) {
        this.nextTipIndex = nextTipIndex;
    }

    public String getDefaultDN() {
        return this.defaultDN;
    }

    public void setDefaultDN(String defaultDN) {
        this.defaultDN = defaultDN;
    }

    public String getSslHosts() {
        return this.sslHosts;
    }

    public void setSslHosts(String sslHosts) {
        this.sslHosts = sslHosts;
    }

    public String getSslPorts() {
        return this.sslPorts;
    }

    public void setSslPorts(String sslPorts) {
        this.sslPorts = sslPorts;
    }

    public boolean isAutoUpdateCheckEnabled() {
        return this.autoUpdateCheckEnabled;
    }

    public void setAutoUpdateCheckEnabled(boolean autoUpdateCheckEnabled) {
        this.autoUpdateCheckEnabled = autoUpdateCheckEnabled;
    }

    public Date getAutoUpdateCheckLastCheck() {
        return this.autoUpdateCheckLastCheck;
    }

    public void setAutoUpdateCheckLastCheck(Date autoUpdateCheckLastCheck) {
        this.autoUpdateCheckLastCheck = autoUpdateCheckLastCheck;
    }

    public int getAutoUpdateCheckInterval() {
        return this.autoUpdateCheckInterval;
    }

    public void setAutoUpdateCheckInterval(int autoUpdateCheckInterval) {
        this.autoUpdateCheckInterval = autoUpdateCheckInterval;
    }

    public String getP11Libs() {
        return this.p11Libs;
    }

    public void setP11Libs(String p11Libs) {
        this.p11Libs = p11Libs;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public KeyStoreTableColumns getKeyStoreTableColumns() {
        return this.kstColumns;
    }

    public void setKeyStoreTableColumns(KeyStoreTableColumns kstColumns) {
        this.kstColumns = kstColumns;
    }

    public int getExpiryWarndays() {
        return this.expiryWarnDays;
    }

    public void setExpiryWarndays(int expiryWarnDays) {
        this.expiryWarnDays = expiryWarnDays;
    }
}

