/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.kse.ApplicationSettings;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.SecurityProvider;
import org.kse.crypto.filetype.CryptoFileUtil;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keystore.KeyStoreLoadException;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.MsCapiStoreType;

public final class KeyStoreUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/keystore/resources");

    private KeyStoreUtil() {
    }

    public static KeyStore create(KeyStoreType keyStoreType) throws CryptoException, IOException {
        if (!keyStoreType.isFileBased()) {
            throw new CryptoException(MessageFormat.format(res.getString("NoCreateKeyStoreNotFile.exception.message"), keyStoreType.jce()));
        }
        KeyStore keyStore = KeyStoreUtil.getKeyStoreInstance(keyStoreType);
        try {
            keyStore.load(null, null);
        }
        catch (NoSuchAlgorithmException | CertificateException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoLoadKeyStoreType.exception.message"), new Object[]{keyStoreType}), ex);
        }
        return keyStore;
    }

    public static KeyStore load(File keyStoreFile, Password password) throws CryptoException, FileNotFoundException {
        KeyStoreType keyStoreType = null;
        try {
            keyStoreType = CryptoFileUtil.detectKeyStoreType(keyStoreFile);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoLoadKeyStore.exception.message"), ex);
        }
        if (keyStoreType == null) {
            return null;
        }
        return KeyStoreUtil.load(keyStoreFile, password, keyStoreType);
    }

    public static KeyStore load(File keyStoreFile, Password password, KeyStoreType keyStoreType) throws CryptoException, FileNotFoundException {
        if (!keyStoreType.isFileBased()) {
            throw new CryptoException(MessageFormat.format(res.getString("NoLoadKeyStoreNotFile.exception.message"), keyStoreType.jce()));
        }
        KeyStore keyStore = KeyStoreUtil.getKeyStoreInstance(keyStoreType);
        try (FileInputStream fis = new FileInputStream(keyStoreFile);){
            if (password.isEmpty() && (keyStoreType == KeyStoreType.JKS || keyStoreType == KeyStoreType.JCEKS)) {
                password.nullPassword();
                keyStore.load(fis, null);
            } else {
                keyStore.load(fis, password.toCharArray());
            }
        }
        catch (NoSuchAlgorithmException | CertificateException ex) {
            throw new KeyStoreLoadException(MessageFormat.format(res.getString("NoLoadKeyStoreType.exception.message"), new Object[]{keyStoreType}), ex, keyStoreType);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new KeyStoreLoadException(MessageFormat.format(res.getString("NoLoadKeyStoreType.exception.message"), new Object[]{keyStoreType}), ex, keyStoreType);
        }
        return keyStore;
    }

    public static boolean isAppleKeychainSupported() {
        return Security.getProvider(SecurityProvider.APPLE.jce()) != null;
    }

    public static KeyStore loadAppleKeychain() throws CryptoException {
        if (!KeyStoreUtil.isAppleKeychainSupported()) {
            throw new CryptoException(res.getString("AppleKeychainNotSupported.exception.message"));
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStoreType.KEYCHAIN.jce(), SecurityProvider.APPLE.jce());
        }
        catch (KeyStoreException | NoSuchProviderException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoCreateKeyStore.exception.message"), KeyStoreType.KEYCHAIN.jce()), ex);
        }
        try {
            keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoLoadKeyStoreType.exception.message"), KeyStoreType.KEYCHAIN.jce()), ex);
        }
        return keyStore;
    }

    public static boolean areMsCapiStoresSupported() {
        return Security.getProvider(SecurityProvider.MS_CAPI.jce()) != null;
    }

    public static KeyStore loadMsCapiStore(MsCapiStoreType msCapiStoreType) throws CryptoException {
        if (!KeyStoreUtil.areMsCapiStoresSupported()) {
            ApplicationSettings.getInstance().setUseWindowsTrustedRootCertificates(false);
            throw new CryptoException(res.getString("MsCapiStoresNotSupported.exception.message"));
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(msCapiStoreType.jce(), SecurityProvider.MS_CAPI.jce());
        }
        catch (KeyStoreException | NoSuchProviderException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoCreateKeyStore.exception.message"), msCapiStoreType.jce()), ex);
        }
        try {
            keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoLoadKeyStoreType.exception.message"), msCapiStoreType.jce()), ex);
        }
        return keyStore;
    }

    public static void save(KeyStore keyStore, File keyStoreFile, Password password) throws CryptoException, IOException {
        KeyStoreType keyStoreType = KeyStoreType.resolveJce(keyStore.getType());
        if (!keyStoreType.isFileBased()) {
            throw new CryptoException(MessageFormat.format(res.getString("NoSaveKeyStoreNotFile.exception.message"), keyStoreType.jce()));
        }
        try (FileOutputStream fos = new FileOutputStream(keyStoreFile);){
            keyStore.store(fos, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CryptoException(res.getString("NoSaveKeyStore.exception.message"), ex);
        }
    }

    public static boolean containsKey(KeyStore keyStore) throws CryptoException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!KeyStoreUtil.isKeyEntry(alias, keyStore)) continue;
                return true;
            }
            return false;
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("NoCheckKeyStoreKeys.exception.message"), ex);
        }
    }

    public static boolean isKeyPairEntry(String alias, KeyStore keyStore) throws KeyStoreException {
        return keyStore.isKeyEntry(alias) && keyStore.getCertificateChain(alias) != null && keyStore.getCertificateChain(alias).length != 0;
    }

    public static boolean isKeyEntry(String alias, KeyStore keyStore) throws KeyStoreException {
        return keyStore.isKeyEntry(alias) && (keyStore.getCertificateChain(alias) == null || keyStore.getCertificateChain(alias).length == 0);
    }

    public static boolean isTrustedCertificateEntry(String alias, KeyStore keyStore) throws KeyStoreException {
        return keyStore.isCertificateEntry(alias);
    }

    public static KeyStore copy(KeyStore keyStore) throws CryptoException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            char[] emptyPassword = new char[]{};
            keyStore.store(baos, emptyPassword);
            KeyStore theCopy = KeyStoreUtil.create(KeyStoreType.resolveJce(keyStore.getType()));
            theCopy.load(new ByteArrayInputStream(baos.toByteArray()), emptyPassword);
            return theCopy;
        }
        catch (IOException | IllegalStateException | GeneralSecurityException | CryptoException ex) {
            throw new CryptoException(res.getString("NoCopyKeyStore.exception.message"), ex);
        }
    }

    private static KeyStore getKeyStoreInstance(KeyStoreType keyStoreType) throws CryptoException {
        try {
            if (keyStoreType == KeyStoreType.BKS || keyStoreType == KeyStoreType.BKS_V1 || keyStoreType == KeyStoreType.UBER || keyStoreType == KeyStoreType.BCFKS) {
                if (Security.getProvider(SecurityProvider.BOUNCY_CASTLE.jce()) == null) {
                    throw new CryptoException(MessageFormat.format(res.getString("NoProvider.exception.message"), SecurityProvider.BOUNCY_CASTLE.jce()));
                }
                return KeyStore.getInstance(keyStoreType.jce(), SecurityProvider.BOUNCY_CASTLE.jce());
            }
            return KeyStore.getInstance(keyStoreType.jce());
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoCreateKeyStore.exception.message"), new Object[]{keyStoreType}), ex);
        }
        catch (NoSuchProviderException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoProvider.exception.message"), SecurityProvider.BOUNCY_CASTLE.jce()));
        }
    }

    public static boolean isECKeyPair(String alias, KeyStore keyStore) throws KeyStoreException {
        if (!KeyStoreUtil.isKeyPairEntry(alias, keyStore)) {
            return false;
        }
        Certificate certificate = keyStore.getCertificate(alias);
        String algorithm = certificate.getPublicKey().getAlgorithm();
        return algorithm.equals(KeyPairType.EC.jce());
    }

    public static boolean isSupportedEntryType(String alias, KeyStore keyStore) throws KeyStoreException {
        Certificate certificate = keyStore.getCertificate(alias);
        return certificate == null || certificate instanceof X509Certificate;
    }
}

