/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DistributionPoint;

public class CRLDistributionPoints
extends ASN1Object {
    List<DistributionPoint> distributionPointList;

    public CRLDistributionPoints(List<DistributionPoint> distributionPointList) {
        this.distributionPointList = distributionPointList;
    }

    public static CRLDistributionPoints getInstance(Object obj) {
        if (obj instanceof CRLDistributionPoints) {
            return (CRLDistributionPoints)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new CRLDistributionPoints((ASN1Sequence)obj);
        }
        if (obj instanceof byte[]) {
            return new CRLDistributionPoints(ASN1Sequence.getInstance((Object)obj));
        }
        throw new IllegalArgumentException("unknown object type");
    }

    private CRLDistributionPoints(ASN1Sequence seq) {
        this.distributionPointList = new ArrayList<DistributionPoint>();
        for (int i = 0; i != seq.size(); ++i) {
            this.distributionPointList.add(DistributionPoint.getInstance((Object)seq.getObjectAt(i)));
        }
    }

    public List<DistributionPoint> getDistributionPointList() {
        return this.distributionPointList;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator<DistributionPoint> it = this.distributionPointList.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next().toASN1Primitive());
        }
        return new DERSequence(v);
    }
}

