/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class PolicyMapping
extends ASN1Object {
    private ASN1ObjectIdentifier issuerDomainPolicy;
    private ASN1ObjectIdentifier subjectDomainPolicy;

    public PolicyMapping(ASN1ObjectIdentifier issuerDomainPolicy, ASN1ObjectIdentifier subjectDomainPolicy) {
        if (subjectDomainPolicy == null) {
            throw new NullPointerException("subjectDomainPolicy must not be null.");
        }
        if (issuerDomainPolicy == null) {
            throw new NullPointerException("issuerDomainPolicy must not be null.");
        }
        this.issuerDomainPolicy = issuerDomainPolicy;
        this.subjectDomainPolicy = subjectDomainPolicy;
    }

    public ASN1ObjectIdentifier getIssuerDomainPolicy() {
        return this.issuerDomainPolicy;
    }

    public ASN1ObjectIdentifier getSubjectDomainPolicy() {
        return this.subjectDomainPolicy;
    }

    public static PolicyMapping getInstance(Object obj) {
        if (obj instanceof PolicyMapping) {
            return (PolicyMapping)((Object)obj);
        }
        if (obj != null) {
            return new PolicyMapping(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private PolicyMapping(ASN1Sequence seq) {
        this.issuerDomainPolicy = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0).toASN1Primitive());
        this.subjectDomainPolicy = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(1).toASN1Primitive());
    }

    public boolean equals(Object paramObject) {
        if (paramObject == null) {
            return false;
        }
        try {
            return Arrays.equals(((ASN1Object)paramObject).getEncoded(), this.getEncoded());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector dv = new ASN1EncodableVector();
        dv.add((ASN1Encodable)this.issuerDomainPolicy);
        dv.add((ASN1Encodable)this.subjectDomainPolicy);
        return new DERSequence(dv);
    }
}

