/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;

public class SubjectInfoAccess
extends ASN1Object {
    private List<AccessDescription> accessDescriptions;

    public SubjectInfoAccess(List<AccessDescription> accessDescriptions) {
        this.accessDescriptions = accessDescriptions;
    }

    public static SubjectInfoAccess getInstance(Object obj) {
        if (obj instanceof SubjectInfoAccess) {
            return (SubjectInfoAccess)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new SubjectInfoAccess((ASN1Sequence)obj);
        }
        if (obj instanceof byte[]) {
            return new SubjectInfoAccess(ASN1Sequence.getInstance((Object)obj));
        }
        throw new IllegalArgumentException("unknown object");
    }

    private SubjectInfoAccess(ASN1Sequence seq) {
        this.accessDescriptions = new Vector<AccessDescription>();
        for (int i = 0; i != seq.size(); ++i) {
            this.accessDescriptions.add(AccessDescription.getInstance((Object)seq.getObjectAt(i)));
        }
    }

    public List<AccessDescription> getAccessDescriptionList() {
        return this.accessDescriptions;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Iterator<AccessDescription> it = this.accessDescriptions.iterator();
        while (it.hasNext()) {
            vec.add((ASN1Encodable)it.next().toASN1Primitive());
        }
        return new DERSequence(vec);
    }
}

