/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum X509ExtensionType {
    ENTRUST_VERSION_INFORMATION("1.2.840.113533.7.65.0", "EntrustVersionInformationCertExt"),
    AUTHORITY_INFORMATION_ACCESS("1.3.6.1.5.5.7.1.1", "AuthorityInformationAccessCertExt"),
    SUBJECT_INFORMATION_ACCESS("1.3.6.1.5.5.7.1.11", "SubjectInformationAccessCertExt"),
    SUBJECT_DIRECTORY_ATTRIBUTES("2.5.29.9", "SubjectDirectoryAttributesCertExt"),
    SUBJECT_KEY_IDENTIFIER("2.5.29.14", "SubjectKeyIdentifierCertExt"),
    KEY_USAGE("2.5.29.15", "KeyUsageCertExt"),
    PRIVATE_KEY_USAGE_PERIOD("2.5.29.16", "PrivateKeyUsagePeriodCertExt"),
    SUBJECT_ALTERNATIVE_NAME("2.5.29.17", "SubjectAlternativeNameCertExt"),
    ISSUER_ALTERNATIVE_NAME("2.5.29.18", "IssuerAlternativeNameCertExt"),
    BASIC_CONSTRAINTS("2.5.29.19", "BasicConstraintsCertExt"),
    CRL_NUMBER("2.5.29.20", "CrlNumberCertExt"),
    REASON_CODE("2.5.29.21", "ReasonCodeCertExt"),
    HOLD_INSTRUCTION_CODE("2.5.29.23", "HoldInstructionCodeCertExt"),
    INVALIDITY_DATE("2.5.29.24", "InvalidityDateCertExt"),
    DELTA_CRL_INDICATOR("2.5.29.27", "DeltaCrlIndicatorCertExt"),
    ISSUING_DISTRIBUTION_POINT("2.5.29.28", "IssuingDistributionPointCertExt"),
    CERTIFICATE_ISSUER("2.5.29.29", "CertificateIssuerCertExt"),
    NAME_CONSTRAINTS("2.5.29.30", "NameConstraintsCertExt"),
    CRL_DISTRIBUTION_POINTS("2.5.29.31", "CrlDistributionPointsCertExt"),
    CERTIFICATE_POLICIES("2.5.29.32", "CertificatePoliciesCertExt"),
    POLICY_MAPPINGS("2.5.29.33", "PolicyMappingsCertExt"),
    AUTHORITY_KEY_IDENTIFIER("2.5.29.35", "AuthorityKeyIdentifierCertExt"),
    POLICY_CONSTRAINTS("2.5.29.36", "PolicyConstraintsCertExt"),
    EXTENDED_KEY_USAGE("2.5.29.37", "ExtendedKeyUsageCertExt"),
    FRESHEST_CRL("2.5.29.46", "FreshestCrlCertExt"),
    INHIBIT_ANY_POLICY("2.5.29.54", "InhibitAnyPolicyCertExt"),
    NETSCAPE_CERTIFICATE_TYPE("2.16.840.1.113730.1.1", "NetscapeCertificateTypeCertExt"),
    NETSCAPE_BASE_URL("2.16.840.1.113730.1.2", "NetscapeBaseUrlCertExt"),
    NETSCAPE_REVOCATION_URL("2.16.840.1.113730.1.3", "NetscapeRevocationUrlCertExt"),
    NETSCAPE_CA_REVOCATION_URL("2.16.840.1.113730.1.4", "NetscapeCaRevocationUrlCertExt"),
    NETSCAPE_CERTIFICATE_RENEWAL_URL("2.16.840.1.113730.1.7", "NetscapeCertificateRenewalUrlCertExt"),
    NETSCAPE_CA_POLICY_URL("2.16.840.1.113730.1.8", "NetscapeCaPolicyUrlCertExt"),
    NETSCAPE_SSL_SERVER_NAME("2.16.840.1.113730.1.12", "NetscapeSslServerNameCertExt"),
    NETSCAPE_COMMENT("2.16.840.1.113730.1.13", "NetscapeCommentCertExt"),
    AUTHORITY_ATTRIBUTE_IDENTIFIER("2.5.29.38", "AuthorityAttributeIdentifierCertExt"),
    ROLE_SPECIFICATION_CERTIFICATE_IDENTIFIER("2.5.29.39", "RoleSpecificationCertificateIdentifierCertExt"),
    CRL_STREAM_IDENTIFIER("2.5.29.40", "CrlStreamIdentifierCertExt"),
    BASIC_ATT_CONSTRAINTS("2.5.29.41", "BaseAttConstraintsCertExt"),
    DELEGATED_NAME_CONSTRAINTS("2.5.29.42", "DelegatedNameConstraintsCertExt"),
    TIME_SPECIFICATION("2.5.29.43", "TimeSpecificationCertExt"),
    CRL_SCOPE("2.5.29.44", "CrlScopeCertExt"),
    STATUS_REFERRALS("2.5.29.45", "StatusReferralsCertExt"),
    ORDERED_LIST("2.5.29.47", "OrderedListCertExt"),
    ATTRIBUTE_DESCRIPTOR("2.5.29.48", "AttributeDescriptorCertExt"),
    USER_NOTICE("2.5.29.49", "UserNoticeCertExt"),
    SOA_IDENTIFIER("2.5.29.50", "SoaIdentifierCertExt"),
    BASE_UPDATE_TIME("2.5.29.51", "BaseUpdateTimeCertExt"),
    ACCEPTABLE_CERTIFICATE_POLICIES("2.5.29.52", "AcceptableCertificatePoliciesCertExt"),
    DELTA_INFORMATION("2.5.29.53", "DeltaInformationCertExt"),
    TARGET_INFORMATION("2.5.29.55", "TargetInformationCertExt"),
    NO_REVOCATION_AVAILABILITY("2.5.29.56", "NoRevocationAvailabilityCertExt"),
    ACCEPTABLE_PRIVILEGE_POLICIES("2.5.29.57", "AcceptablePrivilegePoliciesCertExt"),
    AUTHORITY_KEY_IDENTIFIER_OBS("2.5.29.1", "AuthorityKeyIdentifierObsCertExt"),
    PRIMARY_KEY_ATTRIBUTES_OBS("2.5.29.2", "PrimaryKeyAttributesObsCertExt"),
    CERTIFICATE_POLICIES_OBS("2.5.29.3", "CertificatePoliciesObsCertExt"),
    PRIMARY_KEY_USAGE_RESTRICTION_OBS("2.5.29.4", "PrimaryKeyUsageRestrictionObsCertExt"),
    POLICY_MAPPINGS_OBS("2.5.29.5", "PolicyMappingsObsCertExt"),
    SUBTREES_CONSTRAINT_OBS("2.5.29.6", "SubtreesConstraintObsCertExt"),
    SUBJECT_ALTERNATIVE_NAME_OBS("2.5.29.7", "SubjectAlternativeNameObsCertExt"),
    ISSUER_ALTERNATIVE_NAME_OBS("2.5.29.8", "IssuerAlternativeNameObsCertExt"),
    BASIC_CONSTRAINTS_OBS("2.5.29.10", "BasicConstraintsObsCertExt"),
    NAME_CONSTRAINTS_OBS("2.5.29.11", "NameConstraintsObsCertExt"),
    POLICY_CONSTRAINTS_OBS("2.5.29.12", "PolicyConstraintsObsCertExt"),
    BASIC_CONSTRAINTS_OBS1("2.5.29.13", "BasicConstraintsObsCertExt"),
    EXPIRATION_DATE_OBS("2.5.29.22", "ExpirationDateObsCertExt"),
    CRL_DISTRIBUTION_POINTS_OBS("2.5.29.25", "CrlDistributionPointsObsCertExt"),
    ISSUING_DISTRIBUTION_POINT_OBS("2.5.29.26", "IssuingDistributionPointObsCertExt"),
    POLICY_CONSTRAINTS_OBS1("2.5.29.34", "PolicyConstraintsObsCertExt"),
    BIOMETRIC_INFO("1.3.6.1.5.5.7.1.2", "BiometricInfo"),
    QC_STATEMENTS("1.3.6.1.5.5.7.1.3", "QCStatements"),
    OCSP_NO_CHECK("1.3.6.1.5.5.7.48.1.5", "OCSPNoCheck"),
    LIABILITY_LIMITATION_FLAG("0.2.262.1.10.12.0", "LiabilityLimitationFlag"),
    DATE_OF_CERT_GEN("1.3.36.8.3.1", "DateOfCertGen"),
    PROCURATION("1.3.36.8.3.2", "Procuration"),
    ADMISSION("1.3.36.8.3.3", "Admission"),
    MONETARY_LIMIT("1.3.36.8.3.4", "MonetaryLimit"),
    DECLARATION_OF_MAJORITY("1.3.36.8.3.5", "DeclarationOfMajority"),
    ICCSN("1.3.36.8.3.5", "ICCSN"),
    RESTRICTION("1.3.36.8.3.8", "Restriction"),
    ADDITIONAL_INFORMATION("1.3.36.8.3.15", "AdditionalInformation"),
    VALIDITY_MODEL("1.3.6.1.4.1.8301.3.5", "ValidityModel"),
    MS_ENROLL_CERT_TYPE_EXTENSION("1.3.6.1.4.1.311.20.2", "MSEnrollCerttypeExtension"),
    MS_CA_VERSION("1.3.6.1.4.1.311.21.1", "MSCaVersion"),
    MS_CA_CERTIFICATE_HASH("1.3.6.1.4.1.311.21.2", "MSCACertificateHash"),
    MS_CRL_NEXT_PUBLISH("1.3.6.1.4.1.311.21.4", "MSCRLNextPublish"),
    MS_CERTIFICATE_TEMPLATE("1.3.6.1.4.1.311.21.7", "MSCertificateTemplate"),
    MS_APPLICATION_POLICIES("1.3.6.1.4.1.311.21.10", "MSApplicationPolicies"),
    SMIME_CAPABILITIES("1.2.840.113549.1.9.15", "SMIMECapabilities"),
    LOGO_TYPE("1.3.6.1.5.5.7.1.12", "LogoType"),
    SET_HASHED_ROOT_KEY("2.23.42.7.0", "SETHashedRootKey"),
    SET_CERTIFICATE_TYPE("2.23.42.7.1", "SETCertificateType"),
    SET_MERCHANT_DATA("2.23.42.7.2", "SETMerchantData"),
    SET_CARD_CERT_REQUIRED("2.23.42.7.3", "SETCardCertRequired"),
    SET_TUNNELING("2.23.42.7.4", "SETTunneling"),
    SET_SET_EXTENSIONS("2.23.42.7.5", "SETSetExtensions"),
    SET_SET_QUALIFIER("2.23.42.7.6", "SETSetQualifier"),
    VS_CZAG("2.16.840.1.113733.1.6.3", "VeriSignCZAG"),
    VS_NON_VERIFIED("2.16.840.1.113733.1.6.4", "VeriSignNonVerified"),
    VS_FIDELITY_TOKEN("2.16.840.1.113733.1.6.5", "VeriSignFidelityToken"),
    VS_IN_BOX_V1("2.16.840.1.113733.1.6.6", "VeriSignInBoxV1"),
    VS_SERIAL_NUMBER_ROLLOVER("2.16.840.1.113733.1.6.7", "VeriSignSerialNumberRollover"),
    VS_TOKEN_TYPE("2.16.840.1.113733.1.6.8", "VeriSignTokenType"),
    VS_IN_BOX_V2("2.16.840.1.113733.1.6.10", " VeriSignNetscapeInBoxV2"),
    VS_ON_SITE_JURISDICTION_HASH("2.16.840.1.113733.1.6.11", "VeriSignOnSiteJurisdictionHash"),
    VS_UNKNOWN("2.16.840.1.113733.1.6.13", "VeriSignUnknown"),
    VS_DNB_DUNS_NUMBER("2.16.840.1.113733.1.6.15", "VeriSignDnbDunsNumber"),
    GO_CT_SCTS("1.3.6.1.4.1.11129.2.4.2", "SignedCertificateTimestampList"),
    UNKNOWN("0", "unknown");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private X509ExtensionType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String oid() {
        return this.oid;
    }

    public String friendly() {
        String friendlyName = this.friendlyKey;
        if (res.containsKey(this.friendlyKey)) {
            friendlyName = res.getString(this.friendlyKey);
        }
        return friendlyName;
    }

    public static X509ExtensionType resolveOid(String oid) {
        for (X509ExtensionType type : X509ExtensionType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.friendly();
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

