/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.io.File;
import java.util.Properties;

public class CurrentDirectory {
    private CurrentDirectory() {
    }

    private static void initialiseWorkingDirToBeHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir != null) {
            System.setProperty("user.dir", homeDir);
        }
    }

    public static void update(File directory) {
        if (directory != null && directory.exists()) {
            Properties sysProps = new Properties(System.getProperties());
            sysProps.setProperty("user.dir", directory.getAbsolutePath());
            System.setProperties(sysProps);
        }
    }

    public static void updateForFile(File file) {
        if (file != null) {
            File directory = file.getParentFile();
            CurrentDirectory.update(directory);
        }
    }

    public static File get() {
        return new File(System.getProperty("user.dir"));
    }

    static {
        CurrentDirectory.initialiseWorkingDirToBeHomeDir();
    }
}

