/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.ecc.EccUtil;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ChangeTypeAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;
    private KeyStoreType newType;
    private boolean warnNoChangeKey;
    private boolean warnNoECC;

    public ChangeTypeAction(KseFrame kseFrame, KeyStoreType newType) {
        super(kseFrame);
        this.newType = newType;
        this.putValue("LongDescription", MessageFormat.format(res.getString("ChangeTypeAction.statusbar"), newType.friendly()));
        this.putValue("Name", newType.friendly());
        this.putValue("ShortDescription", newType.friendly());
    }

    @Override
    public String getHistoryDescription() {
        return MessageFormat.format(res.getString("ChangeTypeAction.History.text"), this.newType.friendly());
    }

    @Override
    protected void doAction() {
        KeyStoreType currentType = KeyStoreType.resolveJce(this.kseFrame.getActiveKeyStoreHistory().getCurrentState().getKeyStore().getType());
        if (currentType == this.newType) {
            return;
        }
        boolean changeResult = this.changeKeyStoreType(this.newType);
        if (!changeResult) {
            this.kseFrame.updateControls(false);
        }
    }

    private boolean changeKeyStoreType(KeyStoreType newKeyStoreType) {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStore currentKeyStore = currentState.getKeyStore();
            KeyStore newKeyStore = KeyStoreUtil.create(newKeyStoreType);
            this.resetWarnings();
            Enumeration<String> aliases = currentKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (KeyStoreUtil.isTrustedCertificateEntry(alias, currentKeyStore)) {
                    Certificate trustedCertificate = currentKeyStore.getCertificate(alias);
                    newKeyStore.setCertificateEntry(alias, trustedCertificate);
                    continue;
                }
                if (!(KeyStoreUtil.isKeyPairEntry(alias, currentKeyStore) ? !this.copyKeyPairEntry(newKeyStoreType, currentState, currentKeyStore, newKeyStore, alias) : KeyStoreUtil.isKeyEntry(alias, currentKeyStore) && !this.copySecretKeyEntry(newKeyStoreType, currentState, currentKeyStore, newKeyStore, alias))) continue;
                return false;
            }
            KeyStoreState newState = currentState.createBasisForNextState(this);
            newState.setKeyStore(newKeyStore);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ChangeTypeAction.ChangeKeyStoreTypeSuccessful.message"), res.getString("ChangeTypeAction.ChangeKeyStoreType.Title"), 1);
            return true;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return false;
        }
    }

    private void resetWarnings() {
        this.warnNoChangeKey = false;
        this.warnNoECC = false;
    }

    private boolean copyKeyPairEntry(KeyStoreType newKeyStoreType, KeyStoreState currentState, KeyStore currentKeyStore, KeyStore newKeyStore, String alias) throws KeyStoreException, CryptoException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Certificate[] certificateChain = currentKeyStore.getCertificateChain(alias);
        certificateChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certificateChain));
        Password password = this.getEntryPassword(alias, currentState);
        if (password == null) {
            return false;
        }
        Key privateKey = currentKeyStore.getKey(alias, password.toCharArray());
        currentState.setEntryPassword(alias, password);
        if (KeyStoreUtil.isECKeyPair(alias, currentKeyStore)) {
            String namedCurve = EccUtil.getNamedCurve(currentKeyStore.getKey(alias, password.toCharArray()));
            if (!newKeyStoreType.supportsECC() || !newKeyStoreType.supportsNamedCurve(namedCurve)) {
                return this.showWarnNoECC();
            }
        }
        newKeyStore.setKeyEntry(alias, privateKey, password.toCharArray(), certificateChain);
        return true;
    }

    private boolean copySecretKeyEntry(KeyStoreType newKeyStoreType, KeyStoreState currentState, KeyStore currentKeyStore, KeyStore newKeyStore, String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Password password;
        if (newKeyStoreType.supportsKeyEntries()) {
            password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return false;
            }
        } else {
            return this.showWarnNoChangeKey();
        }
        Key secretKey = currentKeyStore.getKey(alias, password.toCharArray());
        currentState.setEntryPassword(alias, password);
        newKeyStore.setKeyEntry(alias, secretKey, password.toCharArray(), null);
        return true;
    }

    private boolean showWarnNoECC() {
        if (!this.warnNoECC) {
            this.warnNoECC = true;
            int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("ChangeTypeAction.WarnNoECC.message"), res.getString("ChangeTypeAction.ChangeKeyStoreType.Title"), 0);
            if (selected != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean showWarnNoChangeKey() {
        if (!this.warnNoChangeKey) {
            this.warnNoChangeKey = true;
            int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("ChangeTypeAction.WarnNoChangeKey.message"), res.getString("ChangeTypeAction.ChangeKeyStoreType.Title"), 0);
            if (selected != 0) {
                return false;
            }
        }
        return true;
    }
}

