/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.SaveAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class CloseAction
extends SaveAction {
    private static final long serialVersionUID = 1L;

    public CloseAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("CloseAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("CloseAction.statusbar"));
        this.putValue("Name", res.getString("CloseAction.text"));
        this.putValue("ShortDescription", res.getString("CloseAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/close.png"))));
    }

    @Override
    protected void doAction() {
        this.closeActiveKeyStore();
    }

    public boolean closeActiveKeyStore() {
        return this.closeKeyStore(this.kseFrame.getActiveKeyStoreHistory());
    }

    public boolean closeKeyStore(KeyStoreHistory history) {
        KeyStoreState currentState = history.getCurrentState();
        if (this.needSave(currentState)) {
            this.kseFrame.focusOnKeyStore(currentState.getKeyStore());
            int wantSave = this.wantSave(history);
            if (wantSave == 0) {
                boolean saved = this.saveKeyStore(history);
                if (!saved) {
                    return false;
                }
                currentState = history.getCurrentState();
            } else if (wantSave == 2 || wantSave == -1) {
                return false;
            }
        }
        this.kseFrame.removeKeyStore(currentState.getKeyStore());
        this.kseFrame.updateControls(true);
        return true;
    }

    private boolean needSave(KeyStoreState state) {
        return state != null && !state.isSavedState() && !state.isInitialState();
    }

    private int wantSave(KeyStoreHistory history) {
        String keyStoreName = history.getName();
        String message = MessageFormat.format(res.getString("CloseAction.WantSaveChanges.message"), keyStoreName);
        int selected = JOptionPane.showConfirmDialog(this.frame, message, res.getString("CloseAction.WantSaveChanges.Title"), 1);
        return selected;
    }
}

