/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.buffer.Buffer;
import org.kse.utilities.buffer.BufferEntry;
import org.kse.utilities.buffer.KeyBufferEntry;
import org.kse.utilities.buffer.KeyPairBufferEntry;
import org.kse.utilities.buffer.TrustedCertificateBufferEntry;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class CopyAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public CopyAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("CopyAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("CopyAction.statusbar"));
        this.putValue("Name", res.getString("CopyAction.text"));
        this.putValue("ShortDescription", res.getString("CopyAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/copy.png"))));
    }

    @Override
    protected void doAction() {
        List<BufferEntry> bufferEntries = this.bufferSelectedEntries();
        if (bufferEntries != null) {
            Buffer.populate(bufferEntries);
            this.kseFrame.updateControls(false);
        }
    }

    private List<BufferEntry> bufferSelectedEntries() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String[] aliases = this.kseFrame.getSelectedEntryAliases();
            if (aliases.length == 0) {
                return null;
            }
            ArrayList<BufferEntry> bufferEntries = new ArrayList<BufferEntry>();
            for (String alias : aliases) {
                Password password;
                BufferEntry bufferEntry = null;
                KeyStore keyStore = currentState.getKeyStore();
                if (KeyStoreUtil.isKeyEntry(alias, keyStore)) {
                    password = this.getEntryPassword(alias, currentState);
                    if (password == null) continue;
                    Key key = keyStore.getKey(alias, password.toCharArray());
                    if (key instanceof PrivateKey) {
                        JOptionPane.showMessageDialog(this.frame, res.getString("CopyAction.NoCopyKeyEntryWithPrivateKey.message"), res.getString("CopyAction.Copy.Title"), 2);
                        continue;
                    }
                    bufferEntry = new KeyBufferEntry(alias, false, key, password);
                } else if (KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore)) {
                    Certificate certificate = keyStore.getCertificate(alias);
                    bufferEntry = new TrustedCertificateBufferEntry(alias, false, certificate);
                } else if (KeyStoreUtil.isKeyPairEntry(alias, keyStore)) {
                    password = this.getEntryPassword(alias, currentState);
                    if (password == null) continue;
                    PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
                    Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                    bufferEntry = new KeyPairBufferEntry(alias, false, privateKey, password, certificateChain);
                }
                if (bufferEntry == null) continue;
                bufferEntries.add(bufferEntry);
            }
            return bufferEntries;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return null;
        }
    }
}

