/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.filetype.CryptoFileType;
import org.kse.crypto.filetype.CryptoFileUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;

public class DetectFileTypeAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public DetectFileTypeAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("DetectFileTypeAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("DetectFileTypeAction.statusbar"));
        this.putValue("Name", res.getString("DetectFileTypeAction.text"));
        this.putValue("ShortDescription", res.getString("DetectFileTypeAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/detectfiletype.png"))));
    }

    @Override
    protected void doAction() {
        File detectTypeFile = null;
        try {
            JFileChooser chooser = FileChooserFactory.getCertFileChooser();
            chooser.setCurrentDirectory(CurrentDirectory.get());
            chooser.setDialogTitle(res.getString("ExamineFileAction.ExamineFile.Title"));
            chooser.setMultiSelectionEnabled(false);
            chooser.setApproveButtonText(res.getString("DetectFileTypeAction.DetectFileType.button"));
            int rtnValue = chooser.showOpenDialog(this.frame);
            if (rtnValue == 0) {
                detectTypeFile = chooser.getSelectedFile();
                CurrentDirectory.updateForFile(detectTypeFile);
            }
            if (detectTypeFile == null) {
                return;
            }
            CryptoFileType fileType = CryptoFileUtil.detectFileType(detectTypeFile);
            String message = null;
            if (fileType != null) {
                message = MessageFormat.format(res.getString("DetectFileTypeAction.DetectedFileType.message"), detectTypeFile.getName(), fileType.friendly());
            } else {
                StringBuffer sbRecognisedTypes = new StringBuffer();
                for (CryptoFileType type : CryptoFileType.values()) {
                    sbRecognisedTypes.append(MessageFormat.format("<li>{0}</li>", type.friendly()));
                }
                message = MessageFormat.format(res.getString("DetectFileTypeAction.NoDetectFileType.message"), detectTypeFile.getName(), sbRecognisedTypes.toString());
            }
            JOptionPane.showMessageDialog(this.frame, message, res.getString("DetectFileTypeAction.CryptographicFileType.Title"), -1, new ImageIcon(this.getClass().getResource(res.getString("DetectFileTypeAction.DetectFileType.icon"))));
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("DetectFileTypeAction.NoReadFile.message"), detectTypeFile), res.getString("DetectFileTypeAction.DetectFileType.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

