/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.filetype.CryptoFileType;
import org.kse.crypto.filetype.CryptoFileUtil;
import org.kse.crypto.privatekey.MsPvkUtil;
import org.kse.crypto.privatekey.OpenSslPvkUtil;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.publickey.OpenSslPubUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.dialogs.DViewCrl;
import org.kse.gui.dialogs.DViewCsr;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DGetPassword;

public class ExamineFileAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = -6806220856996693050L;

    public ExamineFileAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("ExamineFileAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("ExamineFileAction.statusbar"));
        this.putValue("Name", res.getString("ExamineFileAction.text"));
        this.putValue("ShortDescription", res.getString("ExamineFileAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/examinefile.png"))));
    }

    @Override
    protected void doAction() {
        File file = this.chooseFile();
        this.openFile(file);
    }

    public void openFile(File file) {
        if (file == null) {
            return;
        }
        try {
            CryptoFileType fileType = CryptoFileUtil.detectFileType(file);
            switch (fileType) {
                case JCEKS_KS: 
                case JKS_KS: 
                case PKCS12_KS: 
                case BKS_KS: 
                case BKS_V1_KS: 
                case BCFKS_KS: 
                case UBER_KS: {
                    OpenAction openAction = new OpenAction(this.kseFrame);
                    openAction.openKeyStore(file);
                    break;
                }
                case CERT: {
                    this.openCert(file);
                    break;
                }
                case CRL: {
                    this.openCrl(file);
                    break;
                }
                case PKCS10_CSR: 
                case SPKAC_CSR: {
                    this.openCsr(file, fileType);
                    break;
                }
                case ENC_PKCS8_PVK: 
                case UNENC_PKCS8_PVK: 
                case ENC_OPENSSL_PVK: 
                case UNENC_OPENSSL_PVK: 
                case ENC_MS_PVK: 
                case UNENC_MS_PVK: {
                    this.openPrivateKey(file, fileType);
                    break;
                }
                case OPENSSL_PUB: {
                    this.openPublicKey(file);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("ExamineFileAction.UnknownFileType.message"), file), res.getString("ExamineFileAction.ExamineFile.Title"), 2);
                    break;
                }
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("ExamineFileAction.NotFile.message"), file), res.getString("ExamineFileAction.ExamineFile.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void openCert(File file) throws CryptoException {
        X509Certificate[] certs = this.openCertificate(file);
        if (certs != null && certs.length > 0) {
            DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("ExamineFileAction.CertDetailsFile.Title"), file.getName()), certs, this.kseFrame, DViewCertificate.IMPORT_EXPORT);
            dViewCertificate.setLocationRelativeTo(this.frame);
            dViewCertificate.setVisible(true);
        }
    }

    private void openCrl(File file) {
        if (file == null) {
            return;
        }
        X509CRL crl = null;
        try {
            byte[] data = FileUtils.readFileToByteArray((File)file);
            crl = X509CertUtil.loadCRL(data);
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("ExamineFileAction.NoOpenCrl.Problem"), file.getName());
            String[] causes = new String[]{res.getString("ExamineFileAction.NotCrl.Cause"), res.getString("ExamineFileAction.CorruptedCrl.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ExamineFileAction.ProblemOpeningCrl.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
        }
        if (crl != null) {
            DViewCrl dViewCrl = new DViewCrl(this.frame, MessageFormat.format(res.getString("ExamineFileAction.CrlDetailsFile.Title"), file.getName()), crl);
            dViewCrl.setLocationRelativeTo(this.frame);
            dViewCrl.setVisible(true);
        }
    }

    private void openCsr(File file, CryptoFileType fileType) throws CryptoException {
        DViewCsr dViewCsr;
        if (file == null) {
            return;
        }
        PKCS10CertificationRequest pkcs10Csr = null;
        Spkac spkacCsr = null;
        try {
            byte[] data = FileUtils.readFileToByteArray((File)file);
            if (fileType == CryptoFileType.PKCS10_CSR) {
                pkcs10Csr = Pkcs10Util.loadCsr(data);
            } else if (fileType == CryptoFileType.SPKAC_CSR) {
                spkacCsr = new Spkac(data);
            }
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("ExamineFileAction.NoOpenCsr.Problem"), file.getName());
            String[] causes = new String[]{res.getString("ExamineFileAction.NotCsr.Cause"), res.getString("ExamineFileAction.CorruptedCsr.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ExamineFileAction.ProblemOpeningCsr.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return;
        }
        if (pkcs10Csr != null) {
            dViewCsr = new DViewCsr(this.frame, MessageFormat.format(res.getString("ExamineFileAction.CsrDetailsFile.Title"), file.getName()), pkcs10Csr);
            dViewCsr.setLocationRelativeTo(this.frame);
            dViewCsr.setVisible(true);
        } else {
            dViewCsr = new DViewCsr(this.frame, MessageFormat.format(res.getString("ExamineFileAction.CsrDetailsFile.Title"), file.getName()), spkacCsr);
            dViewCsr.setLocationRelativeTo(this.frame);
            dViewCsr.setVisible(true);
        }
    }

    private void openPrivateKey(File file, CryptoFileType fileType) throws IOException, CryptoException {
        byte[] data = FileUtils.readFileToByteArray((File)file);
        PrivateKey privKey = null;
        Password password = null;
        switch (fileType) {
            case ENC_PKCS8_PVK: {
                password = this.getPassword(file);
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = Pkcs8Util.loadEncrypted(data, password);
                break;
            }
            case UNENC_PKCS8_PVK: {
                privKey = Pkcs8Util.load(data);
                break;
            }
            case ENC_OPENSSL_PVK: {
                password = this.getPassword(file);
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = OpenSslPvkUtil.loadEncrypted(data, password);
                break;
            }
            case UNENC_OPENSSL_PVK: {
                privKey = OpenSslPvkUtil.load(data);
                break;
            }
            case ENC_MS_PVK: {
                password = this.getPassword(file);
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = MsPvkUtil.loadEncrypted(data, password);
                break;
            }
            case UNENC_MS_PVK: {
                privKey = MsPvkUtil.load(data);
                break;
            }
        }
        DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this.frame, MessageFormat.format(res.getString("ExamineFileAction.PrivateKeyDetailsFile.Title"), file.getName()), privKey);
        dViewPrivateKey.setLocationRelativeTo(this.frame);
        dViewPrivateKey.setVisible(true);
    }

    private void openPublicKey(File file) throws IOException, CryptoException {
        byte[] data = FileUtils.readFileToByteArray((File)file);
        PublicKey publicKey = OpenSslPubUtil.load(data);
        DViewPublicKey dViewPublicKey = new DViewPublicKey(this.frame, MessageFormat.format(res.getString("ExamineFileAction.PublicKeyDetailsFile.Title"), file.getName()), publicKey);
        dViewPublicKey.setLocationRelativeTo(this.frame);
        dViewPublicKey.setVisible(true);
    }

    private Password getPassword(File file) {
        DGetPassword dGetPassword = new DGetPassword(this.frame, MessageFormat.format(res.getString("ExamineFileAction.EnterPassword.Title"), file.getName()));
        dGetPassword.setLocationRelativeTo(this.frame);
        dGetPassword.setVisible(true);
        return dGetPassword.getPassword();
    }

    private File chooseFile() {
        JFileChooser chooser = FileChooserFactory.getCertFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("ExamineFileAction.ExamineFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("ExamineFileAction.ExamineFile.button"));
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File openFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(openFile);
            return openFile;
        }
        return null;
    }
}

