/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.privatekey.MsPvkUtil;
import org.kse.crypto.privatekey.OpenSslPbeType;
import org.kse.crypto.privatekey.OpenSslPvkUtil;
import org.kse.crypto.privatekey.Pkcs8PbeType;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.importexport.DExportPrivateKeyOpenSsl;
import org.kse.gui.dialogs.importexport.DExportPrivateKeyPkcs8;
import org.kse.gui.dialogs.importexport.DExportPrivateKeyPvk;
import org.kse.gui.dialogs.importexport.DExportPrivateKeyType;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ExportKeyPairPrivateKeyAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public ExportKeyPairPrivateKeyAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ExportKeyPairPrivateKeyAction.statusbar"));
        this.putValue("Name", res.getString("ExportKeyPairPrivateKeyAction.text"));
        this.putValue("ShortDescription", res.getString("ExportKeyPairPrivateKeyAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/keypairexportpvk.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            DExportPrivateKeyType dExportPrivateKeyType = new DExportPrivateKeyType(this.frame);
            dExportPrivateKeyType.setLocationRelativeTo(this.frame);
            dExportPrivateKeyType.setVisible(true);
            if (!dExportPrivateKeyType.exportTypeSelected()) {
                return;
            }
            if (dExportPrivateKeyType.exportPkcs8()) {
                this.exportAsPkcs8(privateKey, alias);
            } else if (dExportPrivateKeyType.exportPvk()) {
                this.exportAsPvk(privateKey, alias);
            } else {
                this.exportAsOpenSsl(privateKey, alias);
            }
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void exportAsPkcs8(PrivateKey privateKey, String alias) throws CryptoException, IOException {
        File exportFile = null;
        try {
            DExportPrivateKeyPkcs8 dExportPrivateKeyPkcs8 = new DExportPrivateKeyPkcs8(this.frame, alias, this.applicationSettings.getPasswordQualityConfig());
            dExportPrivateKeyPkcs8.setLocationRelativeTo(this.frame);
            dExportPrivateKeyPkcs8.setVisible(true);
            if (!dExportPrivateKeyPkcs8.exportSelected()) {
                return;
            }
            exportFile = dExportPrivateKeyPkcs8.getExportFile();
            boolean pemEncode = dExportPrivateKeyPkcs8.pemEncode();
            boolean encrypt = dExportPrivateKeyPkcs8.encrypt();
            Pkcs8PbeType pbeAlgorithm = null;
            Password exportPassword = null;
            if (encrypt) {
                pbeAlgorithm = dExportPrivateKeyPkcs8.getPbeAlgorithm();
                exportPassword = dExportPrivateKeyPkcs8.getExportPassword();
            }
            byte[] encoded = this.getPkcs8EncodedPrivateKey(privateKey, pemEncode, pbeAlgorithm, exportPassword);
            this.exportEncodedPrivateKey(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPkcs8Successful.message"), res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPkcs8.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairPrivateKeyAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPkcs8.Title"), 2);
        }
    }

    private void exportAsPvk(PrivateKey privateKey, String alias) throws CryptoException, IOException {
        File exportFile = null;
        try {
            DExportPrivateKeyPvk dExportPrivateKeyPvk = new DExportPrivateKeyPvk(this.frame, alias, privateKey, this.applicationSettings.getPasswordQualityConfig());
            dExportPrivateKeyPvk.setLocationRelativeTo(this.frame);
            dExportPrivateKeyPvk.setVisible(true);
            if (!dExportPrivateKeyPvk.exportSelected()) {
                return;
            }
            exportFile = dExportPrivateKeyPvk.getExportFile();
            int keyType = dExportPrivateKeyPvk.getKeyType();
            boolean encrypt = dExportPrivateKeyPvk.encrypt();
            boolean strongEncryption = false;
            Password exportPassword = null;
            if (encrypt) {
                strongEncryption = dExportPrivateKeyPvk.useStrongEncryption();
                exportPassword = dExportPrivateKeyPvk.getExportPassword();
            }
            byte[] encoded = this.getPvkEncodedPrivateKey(privateKey, keyType, exportPassword, strongEncryption);
            this.exportEncodedPrivateKey(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPvkSuccessful.message"), res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPvk.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairPrivateKeyAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyPvk.Title"), 2);
        }
    }

    private void exportAsOpenSsl(PrivateKey privateKey, String alias) throws CryptoException, IOException {
        File exportFile = null;
        try {
            DExportPrivateKeyOpenSsl dExportPrivateKeyOpenSsl = new DExportPrivateKeyOpenSsl(this.frame, alias, this.applicationSettings.getPasswordQualityConfig());
            dExportPrivateKeyOpenSsl.setLocationRelativeTo(this.frame);
            dExportPrivateKeyOpenSsl.setVisible(true);
            if (!dExportPrivateKeyOpenSsl.exportSelected()) {
                return;
            }
            exportFile = dExportPrivateKeyOpenSsl.getExportFile();
            boolean pemEncode = dExportPrivateKeyOpenSsl.pemEncode();
            boolean encrypt = dExportPrivateKeyOpenSsl.encrypt();
            OpenSslPbeType pbeAlgorithm = null;
            Password exportPassword = null;
            if (encrypt) {
                pbeAlgorithm = dExportPrivateKeyOpenSsl.getPbeAlgorithm();
                exportPassword = dExportPrivateKeyOpenSsl.getExportPassword();
            }
            byte[] encoded = this.getOpenSslEncodedPrivateKey(privateKey, pemEncode, pbeAlgorithm, exportPassword);
            this.exportEncodedPrivateKey(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyOpenSslSuccessful.message"), res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyOpenSsl.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairPrivateKeyAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportKeyPairPrivateKeyAction.ExportPrivateKeyOpenSsl.Title"), 2);
        }
    }

    private byte[] getPkcs8EncodedPrivateKey(PrivateKey privateKey, boolean pemEncode, Pkcs8PbeType pbeAlgorithm, Password password) throws CryptoException, IOException {
        byte[] encoded = null;
        encoded = pemEncode ? (pbeAlgorithm != null && password != null ? Pkcs8Util.getEncryptedPem(privateKey, pbeAlgorithm, password).getBytes() : Pkcs8Util.getPem(privateKey).getBytes()) : (pbeAlgorithm != null && password != null ? Pkcs8Util.getEncrypted(privateKey, pbeAlgorithm, password) : Pkcs8Util.get(privateKey));
        return encoded;
    }

    private byte[] getPvkEncodedPrivateKey(PrivateKey privateKey, int keyType, Password password, boolean strongEncryption) throws CryptoException, IOException {
        byte[] encoded = null;
        encoded = password != null ? (privateKey instanceof RSAPrivateCrtKey ? MsPvkUtil.getEncrypted((RSAPrivateCrtKey)privateKey, keyType, password, strongEncryption) : MsPvkUtil.getEncrypted((DSAPrivateKey)privateKey, password, strongEncryption)) : (privateKey instanceof RSAPrivateCrtKey ? MsPvkUtil.get((RSAPrivateCrtKey)privateKey, keyType) : MsPvkUtil.get((DSAPrivateKey)privateKey));
        return encoded;
    }

    private byte[] getOpenSslEncodedPrivateKey(PrivateKey privateKey, boolean pemEncoded, OpenSslPbeType pbeAlgorithm, Password password) throws CryptoException, IOException {
        byte[] encoded = null;
        encoded = pemEncoded ? (pbeAlgorithm != null && password != null ? OpenSslPvkUtil.getEncrypted(privateKey, pbeAlgorithm, password).getBytes() : OpenSslPvkUtil.getPem(privateKey).getBytes()) : OpenSslPvkUtil.get(privateKey);
        return encoded;
    }

    private void exportEncodedPrivateKey(byte[] encoded, File exportFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            fos.write(encoded);
            fos.flush();
        }
    }
}

