/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;

public class KeyPairCertificateChainDetailsAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public KeyPairCertificateChainDetailsAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("KeyPairCertificateChainDetailsAction.statusbar"));
        this.putValue("Name", res.getString("KeyPairCertificateChainDetailsAction.text"));
        this.putValue("ShortDescription", res.getString("KeyPairCertificateChainDetailsAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/certdetails.png"))));
    }

    @Override
    protected void doAction() {
        this.showCertificateSelectedEntry();
    }

    public void showCertificateSelectedEntry() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStore keyStore = history.getCurrentState().getKeyStore();
            String alias = this.kseFrame.getSelectedEntryAlias();
            X509Certificate[] certs = X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias));
            DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("KeyPairCertificateChainDetailsAction.CertDetailsEntry.Title"), alias), certs, this.kseFrame, DViewCertificate.EXPORT);
            dViewCertificate.setLocationRelativeTo(this.frame);
            dViewCertificate.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

