/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.kse.crypto.Password;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class KeyPairPrivateKeyDetailsAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public KeyPairPrivateKeyDetailsAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("KeyPairPrivateKeyDetailsAction.statusbar"));
        this.putValue("Name", res.getString("KeyPairPrivateKeyDetailsAction.text"));
        this.putValue("ShortDescription", res.getString("KeyPairPrivateKeyDetailsAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/privkeydetails.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this.frame, MessageFormat.format(res.getString("KeyPairPrivateKeyDetailsAction.PrivKeyDetailsEntry.Title"), alias), privKey);
            dViewPrivateKey.setLocationRelativeTo(this.frame);
            dViewPrivateKey.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

