/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.PublicKey;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class KeyPairPublicKeyDetailsAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public KeyPairPublicKeyDetailsAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("KeyPairPublicKeyDetailsAction.statusbar"));
        this.putValue("Name", res.getString("KeyPairPublicKeyDetailsAction.text"));
        this.putValue("ShortDescription", res.getString("KeyPairPublicKeyDetailsAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/keypairpubkeydetails.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStore keyStore = currentState.getKeyStore();
            String alias = this.kseFrame.getSelectedEntryAlias();
            PublicKey pubKey = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)))[0].getPublicKey();
            DViewPublicKey dViewPublicKey = new DViewPublicKey(this.frame, MessageFormat.format(res.getString("KeyPairPublicKeyDetailsAction.PubKeyDetailsEntry.Title"), alias), pubKey);
            dViewPublicKey.setLocationRelativeTo(this.frame);
            dViewPublicKey.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

