/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DNewKeyStoreType;
import org.kse.gui.error.DError;

public class NewAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private static int untitledCount = 0;

    public NewAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("NewAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("NewAction.statusbar"));
        this.putValue("Name", res.getString("NewAction.text"));
        this.putValue("ShortDescription", res.getString("NewAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/new.png"))));
    }

    @Override
    protected void doAction() {
        try {
            DNewKeyStoreType dNewKeyStoreType = new DNewKeyStoreType(this.frame);
            dNewKeyStoreType.setLocationRelativeTo(this.frame);
            dNewKeyStoreType.setVisible(true);
            KeyStoreType keyStoreType = dNewKeyStoreType.getKeyStoreType();
            if (keyStoreType == null) {
                return;
            }
            KeyStore newKeyStore = KeyStoreUtil.create(keyStoreType);
            String untitled = MessageFormat.format(res.getString("NewAction.Untitled"), ++untitledCount);
            this.kseFrame.addKeyStore(newKeyStore, untitled, null, null);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

