/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.Provider;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.dialogs.DOpenPkcs11KeyStore;
import org.kse.gui.dialogs.PasswordCallbackHandler;
import org.kse.gui.error.DError;

public class OpenPkcs11Action
extends OpenAction {
    private static final long serialVersionUID = 1L;

    public OpenPkcs11Action(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("OpenPkcs11Action.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.putValue("LongDescription", res.getString("OpenPkcs11Action.statusbar"));
        this.putValue("Name", res.getString("OpenPkcs11Action.text"));
        this.putValue("ShortDescription", res.getString("OpenPkcs11Action.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/openpkcs11.png"))));
    }

    @Override
    protected void doAction() {
        try {
            DOpenPkcs11KeyStore dOpenPkcs11KeyStore = new DOpenPkcs11KeyStore(this.frame);
            dOpenPkcs11KeyStore.setLocationRelativeTo(this.frame);
            dOpenPkcs11KeyStore.setVisible(true);
            Provider selectedProvider = dOpenPkcs11KeyStore.getSelectedProvider();
            if (selectedProvider == null) {
                return;
            }
            KeyStore keyStore = KeyStore.getInstance(KeyStoreType.PKCS11.jce(), selectedProvider);
            AuthProvider authProvider = (AuthProvider)selectedProvider;
            authProvider.setCallbackHandler(new PasswordCallbackHandler(this.frame));
            keyStore.load(null, null);
            this.kseFrame.addKeyStore(keyStore, selectedProvider.getName(), null, selectedProvider);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

