/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DGetAlias;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class RenameTrustedCertificateAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public RenameTrustedCertificateAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("RenameTrustedCertificateAction.statusbar"));
        this.putValue("Name", res.getString("RenameTrustedCertificateAction.text"));
        this.putValue("ShortDescription", res.getString("RenameTrustedCertificateAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/rename.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.renameSelectedEntry();
    }

    public void renameSelectedEntry() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            String alias = this.kseFrame.getSelectedEntryAlias();
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("RenameTrustedCertificateAction.NewEntryAlias.Title"), alias);
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String newAlias = dGetAlias.getAlias();
            if (newAlias == null) {
                return;
            }
            if (newAlias.equalsIgnoreCase(alias)) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("RenameTrustedCertificateAction.RenameAliasIdentical.message"), alias), res.getString("RenameTrustedCertificateAction.RenameEntry.Title"), 2);
                return;
            }
            if (keyStore.containsAlias(newAlias)) {
                String message = MessageFormat.format(res.getString("RenameTrustedCertificateAction.OverWriteEntry.message"), newAlias);
                int selected = JOptionPane.showConfirmDialog(this.frame, message, res.getString("RenameTrustedCertificateAction.RenameEntry.Title"), 0);
                if (selected != 0) {
                    return;
                }
                keyStore.deleteEntry(newAlias);
                newState.removeEntryPassword(newAlias);
            }
            Certificate cert = keyStore.getCertificate(alias);
            keyStore.setCertificateEntry(newAlias, cert);
            keyStore.deleteEntry(alias);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

