/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.SaveAsAction;
import org.kse.gui.actions.SetPasswordAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SaveAction
extends SaveAsAction {
    private static final long serialVersionUID = 1L;

    public SaveAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("SaveAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("SaveAction.statusbar"));
        this.putValue("Name", res.getString("SaveAction.text"));
        this.putValue("ShortDescription", res.getString("SaveAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/save.png"))));
    }

    @Override
    protected void doAction() {
        this.saveKeyStore(this.kseFrame.getActiveKeyStoreHistory());
    }

    public boolean saveKeyStore(KeyStoreHistory history) {
        File saveFile = null;
        try {
            KeyStoreState currentState = history.getCurrentState();
            this.kseFrame.focusOnKeyStore(currentState.getKeyStore());
            saveFile = history.getFile();
            if (saveFile == null) {
                return this.saveKeyStoreAs(history);
            }
            Password password = currentState.getPassword();
            if (password == null || password.isNulled()) {
                SetPasswordAction setPasswordAction = new SetPasswordAction(this.kseFrame);
                if (setPasswordAction.setKeyStorePassword()) {
                    currentState = history.getCurrentState();
                    password = currentState.getPassword();
                } else {
                    return false;
                }
            }
            KeyStoreUtil.save(currentState.getKeyStore(), saveFile, password);
            currentState.setPassword(password);
            currentState.setAsSavedState();
            this.kseFrame.updateControls(false);
            return true;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("SaveAction.NoWriteFile.message"), saveFile), res.getString("SaveAction.SaveKeyStore.Title"), 2);
            return false;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return false;
        }
    }
}

