/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.Password;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.signing.MidletSigner;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.sign.DSignMidlet;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SignMidletAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public SignMidletAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("SignMidletAction.statusbar"));
        this.putValue("Name", res.getString("SignMidletAction.text"));
        this.putValue("ShortDescription", res.getString("SignMidletAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/signmidlet.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            X509Certificate[] certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            if (!privateKey.getAlgorithm().equals(KeyPairType.RSA.jce())) {
                JOptionPane.showMessageDialog(this.frame, res.getString("SignMidletAction.ReqRsaKeyPairMidletSigning.message"), res.getString("SignMidletAction.SignMidlet.Title"), 2);
                return;
            }
            DSignMidlet dSignMidlet = new DSignMidlet(this.frame);
            dSignMidlet.setLocationRelativeTo(this.frame);
            dSignMidlet.setVisible(true);
            File inputJadFile = dSignMidlet.getInputJad();
            File outputJadFile = dSignMidlet.getOutputJad();
            File jarFile = dSignMidlet.getJar();
            if (inputJadFile == null) {
                return;
            }
            if (inputJadFile.equals(outputJadFile)) {
                MidletSigner.sign(inputJadFile, jarFile, (RSAPrivateKey)privateKey, certs, 1);
            } else {
                MidletSigner.sign(inputJadFile, outputJadFile, jarFile, (RSAPrivateKey)privateKey, certs, 1);
            }
            JOptionPane.showMessageDialog(this.frame, res.getString("SignMidletAction.SignMidletSuccessful.message"), res.getString("SignMidletAction.SignMidlet.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

