/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.KSE;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;

public class WebsiteAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private String websiteAddress;

    public WebsiteAction(KseFrame kseFrame, Target target) {
        super(kseFrame);
        switch (target) {
            case GITHUB: {
                this.setData(res.getString("WebsiteAction.GitHubProject.statusbar"), res.getString("WebsiteAction.GitHubProject.text"), res.getString("WebsiteAction.GitHubProject.tooltip"), "images/website.png", "https://github.com/kaikramer/keystore-explorer");
                break;
            }
            case ISSUE_TRACKER: {
                this.setData(res.getString("WebsiteAction.GitHubIssueTracker.statusbar"), res.getString("WebsiteAction.GitHubIssueTracker.text"), res.getString("WebsiteAction.GitHubIssueTracker.tooltip"), "images/website.png", "https://github.com/kaikramer/keystore-explorer/issues");
                break;
            }
            default: {
                this.setData(res.getString("WebsiteAction.statusbar"), res.getString("WebsiteAction.text"), res.getString("WebsiteAction.tooltip"), "images/website.png", "https://keystore-explorer.org");
            }
        }
    }

    private void setData(String longDescription, String name, String shortDescription, String image, String url) {
        this.putValue("LongDescription", longDescription);
        this.putValue("Name", name);
        this.putValue("ShortDescription", shortDescription);
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(image))));
        this.websiteAddress = url;
    }

    @Override
    protected void doAction() {
        try {
            Desktop.getDesktop().browse(URI.create(this.websiteAddress));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("WebsiteAction.NoLaunchBrowser.message"), this.websiteAddress), KSE.getApplicationName(), 1);
        }
    }

    public static enum Target {
        MAIN,
        GITHUB,
        ISSUE_TRACKER;

    }
}

