/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.kse.ApplicationSettings;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dnchooser.DistinguishedNameChooser;
import org.kse.utilities.DialogViewer;

public class DDistinguishedNameChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private DistinguishedNameChooser distinguishedNameChooser;
    private JButton jbReset;
    private JButton jbDefault;
    private JButton jbOK;
    private JButton jbCancel;
    private JPanel jpButtons;
    private boolean editable;
    private X500Name distinguishedName;
    String defaultDN;
    private transient ApplicationSettings applicationSettings = ApplicationSettings.getInstance();

    public DDistinguishedNameChooser(JFrame parent, String title, X500Name distinguishedName, boolean editable) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.distinguishedName = distinguishedName;
        this.editable = editable;
        this.initComponents();
    }

    public DDistinguishedNameChooser(JDialog parent, String title, X500Name distinguishedName, boolean editable) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.distinguishedName = distinguishedName;
        this.editable = editable;
        this.initComponents();
    }

    private void initComponents() {
        this.defaultDN = this.applicationSettings.getDefaultDN();
        this.jbReset = new JButton(res.getString("DDistinguishedNameChooser.jbReset.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbReset, res.getString("DDistinguishedNameChooser.jbReset.mnemonic").charAt(0));
        this.jbReset.setToolTipText(res.getString("DDistinguishedNameChooser.jbReset.tooltip"));
        this.jbDefault = new JButton(res.getString("DDistinguishedNameChooser.jbDefault.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbDefault, res.getString("DDistinguishedNameChooser.jbDefault.mnemonic").charAt(0));
        this.jbDefault.setToolTipText(res.getString("DDistinguishedNameChooser.jbDefault.tooltip"));
        this.jbOK = new JButton(res.getString("DDistinguishedNameChooser.jbOK.text"));
        if (this.editable) {
            this.distinguishedNameChooser = new DistinguishedNameChooser(this.distinguishedName, true, this.defaultDN);
            this.jbCancel = new JButton(res.getString("DDistinguishedNameChooser.jbCancel.text"));
            this.jbCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DDistinguishedNameChooser.this.cancelPressed();
                }
            });
            this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
            this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DDistinguishedNameChooser.this.cancelPressed();
                }
            });
            this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        } else {
            this.distinguishedNameChooser = new DistinguishedNameChooser(this.distinguishedName, false, this.defaultDN);
            this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK);
        }
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[]", "[]"));
        this.layoutContentPane();
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDistinguishedNameChooser.this.okPressed();
            }
        });
        this.jbReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDistinguishedNameChooser.this.resetPressed();
            }
        });
        this.jbDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDistinguishedNameChooser.this.defaultPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DDistinguishedNameChooser.this.okPressed();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DDistinguishedNameChooser.this.distinguishedNameChooser.getFirstTextField().requestFocus();
            }
        });
    }

    private void layoutContentPane() {
        Container pane = this.getContentPane();
        pane.removeAll();
        pane.add((Component)this.distinguishedNameChooser, "left, spanx, wrap");
        if (this.editable) {
            if (this.distinguishedName == null || this.distinguishedName.getRDNs().length == 0) {
                pane.add((Component)this.jbReset, "right, spanx, wrap");
            } else {
                pane.add((Component)this.jbReset, "right, spanx, split 2");
                pane.add((Component)this.jbDefault, "wrap");
            }
        }
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.pack();
        this.validate();
        this.repaint();
    }

    public X500Name getDistinguishedName() {
        return this.distinguishedName;
    }

    protected void defaultPressed() {
        this.distinguishedNameChooser = new DistinguishedNameChooser(new X500Name(this.defaultDN), true, this.defaultDN);
        this.layoutContentPane();
    }

    protected void resetPressed() {
        this.distinguishedNameChooser = new DistinguishedNameChooser(this.distinguishedName, true, this.defaultDN);
        this.layoutContentPane();
    }

    private void okPressed() {
        if (this.editable) {
            X500Name dn = this.distinguishedNameChooser.getDN();
            if (dn == null) {
                return;
            }
            if (dn.toString().isEmpty()) {
                JOptionPane.showMessageDialog(this, res.getString("DDistinguishedNameChooser.ValueReqAtLeastOneField.message"), this.getTitle(), 2);
                return;
            }
            for (RDN rdn : dn.getRDNs(BCStyle.C)) {
                String countryCode = rdn.getFirst().getValue().toString();
                if (countryCode == null || countryCode.length() == 2) continue;
                JOptionPane.showMessageDialog(this, res.getString("DDistinguishedNameChooser.CountryCodeTwoChars.message"), this.getTitle(), 2);
                return;
            }
            this.distinguishedName = dn;
        }
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DDistinguishedNameChooser dialog = new DDistinguishedNameChooser(new JFrame(), "DN Chooser", new X500Name("CN=test, OU=Development, OU=Software, O=ACME Ltd., C=UK, E=test@example.com"), true);
        DialogViewer.run(dialog);
    }
}

