/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.customextkeyusage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.customextkeyusage.CustomExtKeyUsageTableCellRend;
import org.kse.gui.crypto.customextkeyusage.CustomExtKeyUsageTableHeadRend;
import org.kse.gui.crypto.customextkeyusage.CustomExtKeyUsageTableModel;
import org.kse.gui.error.DError;
import org.kse.gui.oid.DObjectIdChooser;
import org.kse.utilities.oid.InvalidObjectIdException;
import org.kse.utilities.oid.ObjectIdComparator;
import org.kse.utilities.os.OperatingSystem;

public class JCustomExtendedKeyUsage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/customextkeyusage/resources");
    private JPanel jpCustomExtKeyUsageButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspCustomExtKeyUsage;
    private JKseTable jtCustomExtKeyUsages;
    private String title;
    private Set<ASN1ObjectIdentifier> objectIds;
    private boolean enabled = true;

    public JCustomExtendedKeyUsage(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_custom_eku.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JCustomExtKeyUsage.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JCustomExtKeyUsage.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JCustomExtendedKeyUsage.this);
                    JCustomExtendedKeyUsage.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JCustomExtendedKeyUsage.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_custom_eku.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JCustomExtKeyUsage.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JCustomExtKeyUsage.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JCustomExtendedKeyUsage.this);
                    JCustomExtendedKeyUsage.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JCustomExtendedKeyUsage.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_custom_eku.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JCustomExtKeyUsage.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JCustomExtKeyUsage.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JCustomExtendedKeyUsage.this);
                    JCustomExtendedKeyUsage.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JCustomExtendedKeyUsage.this);
                }
            }
        });
        this.jpCustomExtKeyUsageButtons = new JPanel();
        this.jpCustomExtKeyUsageButtons.setLayout(new BoxLayout(this.jpCustomExtKeyUsageButtons, 1));
        this.jpCustomExtKeyUsageButtons.add(Box.createVerticalGlue());
        this.jpCustomExtKeyUsageButtons.add(this.jbAdd);
        this.jpCustomExtKeyUsageButtons.add(Box.createVerticalStrut(3));
        this.jpCustomExtKeyUsageButtons.add(this.jbEdit);
        this.jpCustomExtKeyUsageButtons.add(Box.createVerticalStrut(3));
        this.jpCustomExtKeyUsageButtons.add(this.jbRemove);
        this.jpCustomExtKeyUsageButtons.add(Box.createVerticalGlue());
        CustomExtKeyUsageTableModel customExtKeyUsageTableModel = new CustomExtKeyUsageTableModel();
        this.jtCustomExtKeyUsages = new JKseTable(customExtKeyUsageTableModel);
        TableRowSorter<CustomExtKeyUsageTableModel> sorter = new TableRowSorter<CustomExtKeyUsageTableModel>(customExtKeyUsageTableModel);
        sorter.setComparator(0, new ObjectIdComparator());
        this.jtCustomExtKeyUsages.setRowSorter(sorter);
        this.jtCustomExtKeyUsages.setShowGrid(false);
        this.jtCustomExtKeyUsages.setRowMargin(0);
        this.jtCustomExtKeyUsages.getColumnModel().setColumnMargin(0);
        this.jtCustomExtKeyUsages.getTableHeader().setReorderingAllowed(false);
        this.jtCustomExtKeyUsages.setAutoResizeMode(4);
        this.jtCustomExtKeyUsages.setRowHeight(Math.max(18, this.jtCustomExtKeyUsages.getRowHeight()));
        for (int i = 0; i < this.jtCustomExtKeyUsages.getColumnCount(); ++i) {
            TableColumn column = this.jtCustomExtKeyUsages.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new CustomExtKeyUsageTableHeadRend(this.jtCustomExtKeyUsages.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new CustomExtKeyUsageTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtCustomExtKeyUsages.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JCustomExtendedKeyUsage.this.updateButtonControls();
                }
            }
        });
        this.jtCustomExtKeyUsages.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCustomExtendedKeyUsage.this.maybeEditCustomExtKeyUsage(evt);
            }
        });
        this.jtCustomExtKeyUsages.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JCustomExtendedKeyUsage.this);
                        this.deleteLastPressed = false;
                        JCustomExtendedKeyUsage.this.removeSelectedCustomExtKeyUsage();
                    }
                    finally {
                        CursorUtil.setCursorFree(JCustomExtendedKeyUsage.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JCustomExtendedKeyUsage.this);
                        JCustomExtendedKeyUsage.this.removeSelectedCustomExtKeyUsage();
                    }
                    finally {
                        CursorUtil.setCursorFree(JCustomExtendedKeyUsage.this);
                    }
                }
            }
        });
        this.jspCustomExtKeyUsage = PlatformUtil.createScrollPane(this.jtCustomExtKeyUsages, 20, 31);
        this.jspCustomExtKeyUsage.getViewport().setBackground(this.jtCustomExtKeyUsages.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(250, 150));
        this.add((Component)this.jspCustomExtKeyUsage, "Center");
        this.add((Component)this.jpCustomExtKeyUsageButtons, "East");
        this.populate();
    }

    public Set<ASN1ObjectIdentifier> getCustomExtKeyUsages() {
        return this.objectIds;
    }

    public void setCustomExtKeyUsages(Set<ASN1ObjectIdentifier> customExtKeyUsages) {
        this.objectIds = customExtKeyUsages;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspCustomExtKeyUsage.setToolTipText(toolTipText);
        this.jtCustomExtKeyUsages.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.objectIds == null) {
            this.objectIds = new HashSet<ASN1ObjectIdentifier>();
        }
        this.reloadCustomExtKeyUsageTable();
        this.selectFirstCustomExtKeyUsageInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        try {
            DObjectIdChooser dObjectIdChooser = null;
            dObjectIdChooser = container instanceof JDialog ? new DObjectIdChooser((JDialog)container, this.title, null) : new DObjectIdChooser((JFrame)container, this.title, null);
            dObjectIdChooser.setLocationRelativeTo(container);
            dObjectIdChooser.setVisible(true);
            ASN1ObjectIdentifier newObjectId = dObjectIdChooser.getObjectId();
            if (newObjectId == null) {
                return;
            }
            this.objectIds.add(newObjectId);
            this.populate();
            this.selectCustomExtKeyUsageInTable(newObjectId);
        }
        catch (InvalidObjectIdException ex) {
            DError dError = null;
            dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
            dError.setLocationRelativeTo(container);
            dError.setVisible(true);
        }
    }

    private void removePressed() {
        this.removeSelectedCustomExtKeyUsage();
    }

    private void removeSelectedCustomExtKeyUsage() {
        int selectedRow = this.jtCustomExtKeyUsages.getSelectedRow();
        if (selectedRow != -1) {
            ASN1ObjectIdentifier extKeyUsageOid = (ASN1ObjectIdentifier)this.jtCustomExtKeyUsages.getValueAt(selectedRow, 0);
            this.objectIds.remove(extKeyUsageOid);
            this.reloadCustomExtKeyUsageTable();
            this.selectFirstCustomExtKeyUsageInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedCustomExtKeyUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditCustomExtKeyUsage(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtCustomExtKeyUsages.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtCustomExtKeyUsages.setRowSelectionInterval(row, row);
                this.editSelectedCustomExtKeyUsage();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtCustomExtKeyUsages.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedCustomExtKeyUsage() {
        int selectedRow = this.jtCustomExtKeyUsages.getSelectedRow();
        if (selectedRow != -1) {
            ASN1ObjectIdentifier objectId = (ASN1ObjectIdentifier)this.jtCustomExtKeyUsages.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            Window dObjectIdChooser = null;
            try {
                dObjectIdChooser = container instanceof JDialog ? new DObjectIdChooser((JDialog)container, this.title, objectId) : new DObjectIdChooser((JFrame)container, this.title, objectId);
            }
            catch (InvalidObjectIdException e) {
                e.printStackTrace();
            }
            dObjectIdChooser.setLocationRelativeTo(container);
            ((Dialog)dObjectIdChooser).setVisible(true);
            ASN1ObjectIdentifier newObjectId = ((DObjectIdChooser)dObjectIdChooser).getObjectId();
            if (newObjectId == null) {
                return;
            }
            this.objectIds.remove(objectId);
            this.objectIds.add(newObjectId);
            this.populate();
            this.selectCustomExtKeyUsageInTable(newObjectId);
        }
    }

    private void selectCustomExtKeyUsageInTable(ASN1ObjectIdentifier objectId) {
        for (int i = 0; i < this.jtCustomExtKeyUsages.getRowCount(); ++i) {
            if (!objectId.equals(this.jtCustomExtKeyUsages.getValueAt(i, 0))) continue;
            this.jtCustomExtKeyUsages.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadCustomExtKeyUsageTable() {
        this.getCustomExtKeyUsageTableModel().load(this.objectIds);
    }

    private void selectFirstCustomExtKeyUsageInTable() {
        if (this.getCustomExtKeyUsageTableModel().getRowCount() > 0) {
            this.jtCustomExtKeyUsages.changeSelection(0, 0, false, false);
        }
    }

    private CustomExtKeyUsageTableModel getCustomExtKeyUsageTableModel() {
        return (CustomExtKeyUsageTableModel)this.jtCustomExtKeyUsages.getModel();
    }
}

