/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.UserNotice;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DUserNoticeChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpUserNotice;
    private JPanel jpNoticeReference;
    private JLabel jlOrganization;
    private JTextField jtfOrganization;
    private JLabel jlNoticeNumbers;
    private JTextField jtfNoticeNumbers;
    private JPanel jpExplicitText;
    private JLabel jlExplicitText;
    private JTextField jtfExplicitText;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private UserNotice userNotice;

    public DUserNoticeChooser(JFrame parent, String title, UserNotice userNotice) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(userNotice);
    }

    public DUserNoticeChooser(JDialog parent, String title, UserNotice userNotice) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(userNotice);
    }

    private void initComponents(UserNotice userNotice) {
        this.jlOrganization = new JLabel(res.getString("DUserNoticeChooser.jlOrganization.text"));
        GridBagConstraints gbc_jlOrganization = new GridBagConstraints();
        gbc_jlOrganization.gridx = 0;
        gbc_jlOrganization.gridy = 0;
        gbc_jlOrganization.gridwidth = 1;
        gbc_jlOrganization.gridheight = 1;
        gbc_jlOrganization.insets = new Insets(5, 5, 5, 5);
        gbc_jlOrganization.anchor = 13;
        this.jtfOrganization = new JTextField(40);
        this.jtfOrganization.setToolTipText(res.getString("DUserNoticeChooser.jtfOrganization.tooltip"));
        GridBagConstraints gbc_jtfOrganization = new GridBagConstraints();
        gbc_jtfOrganization.gridx = 1;
        gbc_jtfOrganization.gridy = 0;
        gbc_jtfOrganization.gridwidth = 1;
        gbc_jtfOrganization.gridheight = 1;
        gbc_jtfOrganization.insets = new Insets(5, 5, 5, 5);
        gbc_jtfOrganization.anchor = 17;
        this.jlNoticeNumbers = new JLabel(res.getString("DUserNoticeChooser.jlNoticeNumbers.text"));
        GridBagConstraints gbc_jlNoticeNumbers = new GridBagConstraints();
        gbc_jlNoticeNumbers.gridx = 0;
        gbc_jlNoticeNumbers.gridy = 1;
        gbc_jlNoticeNumbers.gridwidth = 1;
        gbc_jlNoticeNumbers.gridheight = 1;
        gbc_jlNoticeNumbers.insets = new Insets(5, 5, 5, 5);
        gbc_jlNoticeNumbers.anchor = 13;
        this.jtfNoticeNumbers = new JTextField(20);
        this.jtfNoticeNumbers.setToolTipText(res.getString("DUserNoticeChooser.jtfNoticeNumbers.tooltip"));
        GridBagConstraints gbc_jtfNoticeNumbers = new GridBagConstraints();
        gbc_jtfNoticeNumbers.gridx = 1;
        gbc_jtfNoticeNumbers.gridy = 1;
        gbc_jtfNoticeNumbers.gridwidth = 1;
        gbc_jtfNoticeNumbers.gridheight = 1;
        gbc_jtfNoticeNumbers.insets = new Insets(5, 5, 5, 5);
        gbc_jtfNoticeNumbers.anchor = 17;
        this.jpNoticeReference = new JPanel(new GridBagLayout());
        this.jpNoticeReference.setBorder(new TitledBorder(res.getString("DUserNoticeChooser.jpNoticeReference.text")));
        this.jpNoticeReference.add((Component)this.jlOrganization, gbc_jlOrganization);
        this.jpNoticeReference.add((Component)this.jtfOrganization, gbc_jtfOrganization);
        this.jpNoticeReference.add((Component)this.jlNoticeNumbers, gbc_jlNoticeNumbers);
        this.jpNoticeReference.add((Component)this.jtfNoticeNumbers, gbc_jtfNoticeNumbers);
        this.jlExplicitText = new JLabel(res.getString("DUserNoticeChooser.jlExplicitText.text"));
        this.jtfExplicitText = new JTextField(40);
        this.jtfExplicitText.setToolTipText(res.getString("DUserNoticeChooser.jtfExplicitText.tooltip"));
        this.jpExplicitText = new JPanel(new FlowLayout(0));
        this.jpExplicitText.add(this.jlExplicitText);
        this.jpExplicitText.add(this.jtfExplicitText);
        this.jpUserNotice = new JPanel(new BorderLayout());
        this.jpUserNotice.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpUserNotice.add((Component)this.jpNoticeReference, "Center");
        this.jpUserNotice.add((Component)this.jpExplicitText, "South");
        this.jbOK = new JButton(res.getString("DUserNoticeChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUserNoticeChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DUserNoticeChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUserNoticeChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUserNoticeChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpUserNotice);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(userNotice);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(UserNotice userNotice) {
        if (userNotice != null) {
            DisplayText explicitText;
            NoticeReference noticeReference = userNotice.getNoticeRef();
            if (noticeReference != null) {
                DisplayText organization = noticeReference.getOrganization();
                if (organization != null) {
                    this.jtfOrganization.setText(organization.getString());
                    this.jtfOrganization.setCaretPosition(0);
                }
                this.populateNoticeNumbers(noticeReference);
            }
            if ((explicitText = userNotice.getExplicitText()) != null) {
                this.jtfExplicitText.setText(explicitText.getString());
                this.jtfExplicitText.setCaretPosition(0);
            }
        }
    }

    private void populateNoticeNumbers(NoticeReference noticeReference) {
        ASN1Integer[] noticeNumbers = noticeReference.getNoticeNumbers();
        if (noticeNumbers != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < noticeNumbers.length; ++i) {
                ASN1Integer noticeNumber = noticeNumbers[i];
                sb.append(noticeNumber.getValue().intValue());
                if (i + 1 >= noticeNumbers.length) continue;
                sb.append(" ");
            }
            this.jtfNoticeNumbers.setText(sb.toString());
            this.jtfNoticeNumbers.setCaretPosition(0);
        }
    }

    public UserNotice getUserNotice() {
        return this.userNotice;
    }

    private void okPressed() {
        String organizationString = this.jtfOrganization.getText().trim();
        int[] noticeNumberInts = this.extractNoticeNumbers();
        String explicitTextString = this.jtfExplicitText.getText().trim();
        if (noticeNumberInts == null) {
            JOptionPane.showMessageDialog(this, res.getString("DUserNoticeChooser.InvalidNoticeNumbers.message"), this.getTitle(), 2);
            return;
        }
        if (organizationString.length() > 0 && noticeNumberInts.length == 0 || organizationString.length() == 0 && noticeNumberInts.length > 0) {
            JOptionPane.showMessageDialog(this, res.getString("DUserNoticeChooser.OrganizationOrNoticeNumbersValueReq.message"), this.getTitle(), 2);
            return;
        }
        if (organizationString.length() == 0 && noticeNumberInts.length == 0 && explicitTextString.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DUserNoticeChooser.NoticeRefOrExplicitTextValueReq.message"), this.getTitle(), 2);
            return;
        }
        NoticeReference noticeReference = null;
        if (organizationString.length() > 0) {
            Vector<ASN1Integer> noticeNumbers = new Vector<ASN1Integer>();
            for (int noticeNumber : noticeNumberInts) {
                noticeNumbers.add(new ASN1Integer((long)noticeNumber));
            }
            noticeReference = new NoticeReference(organizationString, noticeNumbers);
        }
        this.userNotice = new UserNotice(noticeReference, explicitTextString);
        this.closeDialog();
    }

    private int[] extractNoticeNumbers() {
        String noticeNumbersString = this.jtfNoticeNumbers.getText().trim();
        StringTokenizer strTokCnt = new StringTokenizer(noticeNumbersString, " ", false);
        int arcCount = strTokCnt.countTokens();
        StringTokenizer strTok = new StringTokenizer(noticeNumbersString, " ", true);
        boolean expectDelimiter = false;
        int[] noticeNumbers = new int[arcCount];
        int i = 0;
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!(!expectDelimiter || token.equals(" ") && strTok.hasMoreTokens())) {
                return null;
            }
            if (!expectDelimiter) {
                try {
                    noticeNumbers[i] = Integer.parseInt(token);
                    ++i;
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            expectDelimiter = !expectDelimiter;
        }
        return noticeNumbers;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

