/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policyinformation.DPolicyInformationChooser;
import org.kse.gui.crypto.policyinformation.PolicyInformationTableCellRend;
import org.kse.gui.crypto.policyinformation.PolicyInformationTableHeadRend;
import org.kse.gui.crypto.policyinformation.PolicyInformationTableModel;
import org.kse.gui.error.DError;
import org.kse.utilities.os.OperatingSystem;

public class JPolicyInformation
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private JPanel jpPolicyInformationButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspPolicyInformation;
    private JKseTable jtPolicyInformation;
    private String title;
    private List<PolicyInformation> policyInformation;
    private boolean enabled = true;

    public JPolicyInformation(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_policy_info.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JPolicyInformation.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JPolicyInformation.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyInformation.this);
                    JPolicyInformation.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyInformation.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_policy_info.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JPolicyInformation.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JPolicyInformation.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyInformation.this);
                    JPolicyInformation.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyInformation.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_policy_info.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JPolicyInformation.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JPolicyInformation.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyInformation.this);
                    JPolicyInformation.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyInformation.this);
                }
            }
        });
        this.jpPolicyInformationButtons = new JPanel();
        this.jpPolicyInformationButtons.setLayout(new BoxLayout(this.jpPolicyInformationButtons, 1));
        this.jpPolicyInformationButtons.add(Box.createVerticalGlue());
        this.jpPolicyInformationButtons.add(this.jbAdd);
        this.jpPolicyInformationButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyInformationButtons.add(this.jbEdit);
        this.jpPolicyInformationButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyInformationButtons.add(this.jbRemove);
        this.jpPolicyInformationButtons.add(Box.createVerticalGlue());
        PolicyInformationTableModel policyInformationTableModel = new PolicyInformationTableModel();
        this.jtPolicyInformation = new JKseTable(policyInformationTableModel);
        TableRowSorter<PolicyInformationTableModel> sorter = new TableRowSorter<PolicyInformationTableModel>(policyInformationTableModel);
        sorter.setComparator(0, new PolicyInformationTableModel.PolicyInformationComparator());
        this.jtPolicyInformation.setRowSorter(sorter);
        this.jtPolicyInformation.setShowGrid(false);
        this.jtPolicyInformation.setRowMargin(0);
        this.jtPolicyInformation.getColumnModel().setColumnMargin(0);
        this.jtPolicyInformation.getTableHeader().setReorderingAllowed(false);
        this.jtPolicyInformation.setAutoResizeMode(4);
        this.jtPolicyInformation.setRowHeight(Math.max(18, this.jtPolicyInformation.getRowHeight()));
        for (int i = 0; i < this.jtPolicyInformation.getColumnCount(); ++i) {
            TableColumn column = this.jtPolicyInformation.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new PolicyInformationTableHeadRend(this.jtPolicyInformation.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new PolicyInformationTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtPolicyInformation.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JPolicyInformation.this.updateButtonControls();
                }
            }
        });
        this.jtPolicyInformation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPolicyInformation.this.maybeEditPolicyInformation(evt);
            }
        });
        this.jtPolicyInformation.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JPolicyInformation.this);
                        this.deleteLastPressed = false;
                        JPolicyInformation.this.removeSelectedPolicyInformation();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyInformation.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JPolicyInformation.this);
                        JPolicyInformation.this.removeSelectedPolicyInformation();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyInformation.this);
                    }
                }
            }
        });
        this.jspPolicyInformation = PlatformUtil.createScrollPane(this.jtPolicyInformation, 20, 31);
        this.jspPolicyInformation.getViewport().setBackground(this.jtPolicyInformation.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(250, 150));
        this.add((Component)this.jspPolicyInformation, "Center");
        this.add((Component)this.jpPolicyInformationButtons, "East");
        this.populate();
    }

    public List<PolicyInformation> getPolicyInformation() {
        return this.policyInformation;
    }

    public void setPolicyInformation(List<PolicyInformation> policyInformation) {
        this.policyInformation = policyInformation;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspPolicyInformation.setToolTipText(toolTipText);
        this.jtPolicyInformation.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.policyInformation == null) {
            this.policyInformation = new ArrayList<PolicyInformation>();
        }
        this.reloadPolicyInformationTable();
        this.selectFirstPolicyInformationInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        try {
            DPolicyInformationChooser dPolicyInformationChooser = null;
            dPolicyInformationChooser = container instanceof JDialog ? new DPolicyInformationChooser((JDialog)container, this.title, null) : new DPolicyInformationChooser((JFrame)container, this.title, null);
            dPolicyInformationChooser.setLocationRelativeTo(container);
            dPolicyInformationChooser.setVisible(true);
            PolicyInformation newPolicyInfo = dPolicyInformationChooser.getPolicyInformation();
            if (newPolicyInfo == null) {
                return;
            }
            this.policyInformation.add(newPolicyInfo);
            this.populate();
            this.selectPolicyInformationInTable(newPolicyInfo);
        }
        catch (IOException ex) {
            DError dError = null;
            dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
            dError.setLocationRelativeTo(container);
            dError.setVisible(true);
        }
    }

    private void removePressed() {
        this.removeSelectedPolicyInformation();
    }

    private void removeSelectedPolicyInformation() {
        int selectedRow = this.jtPolicyInformation.getSelectedRow();
        if (selectedRow != -1) {
            PolicyInformation policyInfo = (PolicyInformation)this.jtPolicyInformation.getValueAt(selectedRow, 0);
            this.policyInformation.remove(policyInfo);
            this.reloadPolicyInformationTable();
            this.selectFirstPolicyInformationInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedPolicyInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditPolicyInformation(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtPolicyInformation.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtPolicyInformation.setRowSelectionInterval(row, row);
                this.editSelectedPolicyInformation();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtPolicyInformation.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedPolicyInformation() {
        int selectedRow = this.jtPolicyInformation.getSelectedRow();
        if (selectedRow != -1) {
            PolicyInformation policyInfo = (PolicyInformation)this.jtPolicyInformation.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            try {
                DPolicyInformationChooser dPolicyNameChooser = null;
                dPolicyNameChooser = container instanceof JDialog ? new DPolicyInformationChooser((JDialog)container, this.title, policyInfo) : new DPolicyInformationChooser((JFrame)container, this.title, policyInfo);
                dPolicyNameChooser.setLocationRelativeTo(container);
                dPolicyNameChooser.setVisible(true);
                PolicyInformation newPolicyInfo = dPolicyNameChooser.getPolicyInformation();
                if (newPolicyInfo == null) {
                    return;
                }
                this.policyInformation.remove(policyInfo);
                this.policyInformation.add(newPolicyInfo);
                this.populate();
                this.selectPolicyInformationInTable(newPolicyInfo);
            }
            catch (IOException ex) {
                DError dError = null;
                dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
                dError.setLocationRelativeTo(container);
                dError.setVisible(true);
            }
        }
    }

    private void selectPolicyInformationInTable(PolicyInformation policyInfo) {
        for (int i = 0; i < this.jtPolicyInformation.getRowCount(); ++i) {
            if (!policyInfo.equals(this.jtPolicyInformation.getValueAt(i, 0))) continue;
            this.jtPolicyInformation.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadPolicyInformationTable() {
        this.getPolicyInformationTableModel().load(this.policyInformation);
    }

    private void selectFirstPolicyInformationInTable() {
        if (this.getPolicyInformationTableModel().getRowCount() > 0) {
            this.jtPolicyInformation.changeSelection(0, 0, false, false);
        }
    }

    private PolicyInformationTableModel getPolicyInformationTableModel() {
        return (PolicyInformationTableModel)this.jtPolicyInformation.getModel();
    }
}

