/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.kse.crypto.x509.PolicyInformationUtil;

public class PolicyInformationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private String[] columnNames = new String[1];
    private Object[][] data;

    public PolicyInformationTableModel() {
        this.columnNames[0] = res.getString("PolicyInformationTableModel.PolicyInformationColumn");
        this.data = new Object[0][0];
    }

    public void load(List<PolicyInformation> policyInformation) {
        PolicyInformation[] policyInformationArray = policyInformation.toArray(new PolicyInformation[policyInformation.size()]);
        Arrays.sort(policyInformationArray, new PolicyInformationComparator());
        this.data = new Object[policyInformation.size()][1];
        int i = 0;
        for (PolicyInformation policyInfo : policyInformationArray) {
            this.data[i][0] = policyInfo;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return PolicyInformation.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    static class PolicyInformationComparator
    implements Comparator<PolicyInformation> {
        PolicyInformationComparator() {
        }

        @Override
        public int compare(PolicyInformation policyInformation1, PolicyInformation policyInformation2) {
            try {
                return PolicyInformationUtil.toString(policyInformation1).compareToIgnoreCase(PolicyInformationUtil.toString(policyInformation2));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

