/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DGetAlias
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpAlias;
    private JLabel jlAlias;
    private JTextField jtfAlias;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private String alias;

    public DGetAlias(JFrame parent, String title, String alias) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(alias);
    }

    public DGetAlias(JDialog parent, String title, Dialog.ModalityType modality, String alias) {
        super((Window)parent, title, modality);
        this.initComponents(alias);
    }

    public String getAlias() {
        return this.alias;
    }

    private void initComponents(final String alias) {
        this.getContentPane().setLayout(new BorderLayout());
        this.jlAlias = new JLabel(res.getString("DGetAlias.jlAlias.text"));
        this.jtfAlias = new JTextField(15);
        if (alias != null) {
            this.jtfAlias.setText(alias);
            this.jtfAlias.setCaretPosition(0);
        }
        this.jbOK = new JButton(res.getString("DGetAlias.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetAlias.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DGetAlias.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetAlias.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGetAlias.this.cancelPressed();
            }
        });
        this.jpAlias = new JPanel(new FlowLayout(1));
        this.jpAlias.add(this.jlAlias);
        this.jpAlias.add(this.jtfAlias);
        this.jpAlias.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().add((Component)this.jpAlias, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGetAlias.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DGetAlias.this.jtfAlias.requestFocus();
                if (alias != null) {
                    DGetAlias.this.jtfAlias.setSelectionStart(0);
                    DGetAlias.this.jtfAlias.setSelectionEnd(alias.length());
                }
            }
        });
    }

    private boolean checkAlias() {
        String alias = this.jtfAlias.getText().trim().toLowerCase();
        if (alias.length() > 0) {
            this.alias = alias;
            return true;
        }
        JOptionPane.showMessageDialog(this, res.getString("DGetAlias.AliasReq.message"), this.getTitle(), 2);
        return false;
    }

    private void okPressed() {
        if (this.checkAlias()) {
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

