/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.crypto.SecretKey;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.Password;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.crypto.secretkey.SecretKeyUtil;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.PropertiesTreeCellRend;
import org.kse.utilities.StringUtils;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;
import org.kse.utilities.io.IndentChar;
import org.kse.utilities.io.IndentSequence;

public class DProperties
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String NEWLINE = "\n";
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpProperties;
    private JTree jtrProperties;
    private JScrollPane jspProperties;
    private KeyStoreHistory history;
    private KeyStoreState currentState;
    private IndentSequence INDENT = new IndentSequence(IndentChar.SPACE, 4);

    public DProperties(JFrame parent, KeyStoreHistory history) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.history = history;
        this.currentState = history.getCurrentState();
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jbCopy = new JButton(res.getString("DProperties.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DProperties.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DProperties.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DProperties.this);
                    DProperties.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DProperties.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DProperties.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DProperties.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpProperties = new JPanel(new BorderLayout());
        this.jpProperties.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtrProperties = new JTree(this.createPropertiesNodes());
        this.jtrProperties.setRowHeight(Math.max(18, this.jtrProperties.getRowHeight()));
        this.jtrProperties.setShowsRootHandles(true);
        this.jtrProperties.setRootVisible(false);
        this.jtrProperties.getSelectionModel().setSelectionMode(1);
        this.jtrProperties.setCellRenderer(new PropertiesTreeCellRend());
        TreeNode topNode = (TreeNode)this.jtrProperties.getModel().getRoot();
        this.expandTwoLevels(new TreePath(topNode));
        this.jspProperties = PlatformUtil.createScrollPane(this.jtrProperties, 22, 32);
        this.jspProperties.setPreferredSize(new Dimension(400, 250));
        this.jpProperties.add((Component)this.jspProperties, "Center");
        this.getContentPane().add((Component)this.jpProperties, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setTitle(MessageFormat.format(res.getString("DProperties.Title"), this.history.getName()));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DProperties.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DProperties.this.jbOK.requestFocus();
            }
        });
    }

    private DefaultMutableTreeNode createPropertiesNodes() throws CryptoException {
        KeyStore keyStore = this.currentState.getKeyStore();
        String root = MessageFormat.format(res.getString("DProperties.properties.Root"), this.history.getName());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root);
        String file = this.history.getPath();
        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.File"), file));
        rootNode.add(fileNode);
        String type = keyStore.getType();
        DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Type"), type));
        rootNode.add(typeNode);
        String provider = keyStore.getProvider().getName();
        DefaultMutableTreeNode providerNode = new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Provider"), provider));
        rootNode.add(providerNode);
        this.createKeysNodes(rootNode);
        this.createKeyPairsNodes(rootNode);
        this.createTrustedCertificatesNodes(rootNode);
        return rootNode;
    }

    private TreeSet<String> getAliasesInAlphaOrder() throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            TreeSet<String> aliases = new TreeSet<String>();
            Enumeration<String> enumAliases = keyStore.aliases();
            while (enumAliases.hasMoreElements()) {
                String alias = enumAliases.nextElement();
                if (!KeyStoreUtil.isSupportedEntryType(alias, keyStore)) continue;
                aliases.add(alias);
            }
            return aliases;
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createTrustedCertificatesNodes(DefaultMutableTreeNode parentNode) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            TreeSet<String> aliases = this.getAliasesInAlphaOrder();
            DefaultMutableTreeNode trustCertsNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.TrustedCertificates"));
            parentNode.add(trustCertsNode);
            boolean trustCertsPresent = false;
            for (String alias : aliases) {
                if (!KeyStoreUtil.isTrustedCertificateEntry(alias, keyStore)) continue;
                this.createTrustedCertificateNodes(trustCertsNode, alias);
                trustCertsPresent = true;
            }
            if (!trustCertsPresent) {
                DefaultMutableTreeNode emptyTrustCertsNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.None"));
                trustCertsNode.add(emptyTrustCertsNode);
            }
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createTrustedCertificateNodes(DefaultMutableTreeNode parentNode, String alias) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            DefaultMutableTreeNode trustedCertificateNode = new DefaultMutableTreeNode(alias);
            parentNode.add(trustedCertificateNode);
            this.createLastModifiedNode(trustedCertificateNode, alias);
            X509Certificate trustedCertificate = X509CertUtil.convertCertificate(keyStore.getCertificate(alias));
            this.populateCertificateNode(trustedCertificateNode, trustedCertificate);
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void populateCertificateNode(DefaultMutableTreeNode certificateNode, X509Certificate certificate) throws CryptoException {
        try {
            String version = MessageFormat.format(res.getString("DProperties.properties.Version"), "" + certificate.getVersion());
            certificateNode.add(new DefaultMutableTreeNode(version));
            String subject = MessageFormat.format(res.getString("DProperties.properties.Subject"), X500NameUtils.x500PrincipalToX500Name(certificate.getSubjectX500Principal()));
            certificateNode.add(new DefaultMutableTreeNode(subject));
            String issuer = MessageFormat.format(res.getString("DProperties.properties.Issuer"), X500NameUtils.x500PrincipalToX500Name(certificate.getIssuerX500Principal()));
            certificateNode.add(new DefaultMutableTreeNode(issuer));
            String serialNumber = MessageFormat.format(res.getString("DProperties.properties.SerialNumber"), new BigInteger(certificate.getSerialNumber().toByteArray()).toString(16).toUpperCase());
            certificateNode.add(new DefaultMutableTreeNode(serialNumber));
            Date validFromDate = certificate.getNotBefore();
            String validFrom = MessageFormat.format(res.getString("DProperties.properties.ValidFrom"), StringUtils.formatDate(validFromDate));
            certificateNode.add(new DefaultMutableTreeNode(validFrom));
            Date validUntilDate = certificate.getNotAfter();
            String validUntil = MessageFormat.format(res.getString("DProperties.properties.ValidUntil"), StringUtils.formatDate(validUntilDate));
            certificateNode.add(new DefaultMutableTreeNode(validUntil));
            this.createPublicKeyNodes(certificateNode, certificate);
            String signatureAlgorithm = MessageFormat.format(res.getString("DProperties.properties.SignatureAlgorithm"), X509CertUtil.getCertificateSignatureAlgorithm(certificate));
            certificateNode.add(new DefaultMutableTreeNode(signatureAlgorithm));
            byte[] cert = certificate.getEncoded();
            String md5 = MessageFormat.format(res.getString("DProperties.properties.Md5Fingerprint"), DigestUtil.getFriendlyMessageDigest(cert, DigestType.MD5));
            certificateNode.add(new DefaultMutableTreeNode(md5));
            String sha1 = MessageFormat.format(res.getString("DProperties.properties.Sha1Fingerprint"), DigestUtil.getFriendlyMessageDigest(cert, DigestType.SHA1));
            certificateNode.add(new DefaultMutableTreeNode(sha1));
        }
        catch (CertificateEncodingException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createPublicKeyNodes(DefaultMutableTreeNode parentNode, X509Certificate certificate) throws CryptoException {
        this.createPublicKeyNodes(parentNode, certificate.getPublicKey());
    }

    private void createPublicKeyNodes(DefaultMutableTreeNode parentNode, PublicKey publicKey) throws CryptoException {
        DefaultMutableTreeNode publicKeyNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.PublicKey"));
        parentNode.add(publicKeyNode);
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(publicKey);
        String keyAlg = keyInfo.getAlgorithm();
        publicKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Algorithm"), keyAlg)));
        Integer keySize = keyInfo.getSize();
        if (keySize != null) {
            publicKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "" + keyInfo.getSize())));
        } else {
            publicKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "?")));
        }
        String keyFormat = publicKey.getFormat();
        publicKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Format"), keyFormat)));
        String keyEncoded = "0x" + new BigInteger(1, publicKey.getEncoded()).toString(16).toUpperCase();
        publicKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Encoded"), keyEncoded)));
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            String publicExponent = MessageFormat.format(res.getString("DProperties.properties.public.rsa.PublicExponent"), "0x" + rsaPublicKey.getPublicExponent().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(publicExponent));
            String modulus = MessageFormat.format(res.getString("DProperties.properties.public.rsa.Modulus"), "0x" + rsaPublicKey.getModulus().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(modulus));
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            DSAParams dsaParams = dsaPublicKey.getParams();
            String primeModulusP = MessageFormat.format(res.getString("DProperties.properties.public.dsa.PrimeModulusP"), "0x" + dsaParams.getP().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(primeModulusP));
            String primeQ = MessageFormat.format(res.getString("DProperties.properties.public.dsa.PrimeQ"), "0x" + dsaParams.getQ().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(primeQ));
            String generatorG = MessageFormat.format(res.getString("DProperties.properties.public.dsa.GeneratorG"), "0x" + dsaParams.getG().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(generatorG));
            String publicKeyY = MessageFormat.format(res.getString("DProperties.properties.public.dsa.PublicKeyY"), "0x" + dsaPublicKey.getY().toString(16).toUpperCase());
            publicKeyNode.add(new DefaultMutableTreeNode(publicKeyY));
        }
    }

    private void createKeyPairsNodes(DefaultMutableTreeNode parentNode) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            TreeSet<String> aliases = this.getAliasesInAlphaOrder();
            DefaultMutableTreeNode keyPairsNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.KeyPairs"));
            parentNode.add(keyPairsNode);
            boolean keyPairsPresent = false;
            for (String alias : aliases) {
                if (!KeyStoreUtil.isKeyPairEntry(alias, keyStore)) continue;
                this.createKeyPairNodes(keyPairsNode, alias);
                keyPairsPresent = true;
            }
            if (!keyPairsPresent) {
                DefaultMutableTreeNode emptyKeyPairNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.None"));
                keyPairsNode.add(emptyKeyPairNode);
            }
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createKeyPairNodes(DefaultMutableTreeNode parentNode, String alias) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            DefaultMutableTreeNode keyPairNode = new DefaultMutableTreeNode(alias);
            parentNode.add(keyPairNode);
            this.createLastModifiedNode(keyPairNode, alias);
            this.createPrivateKeyNodes(keyPairNode, alias);
            X509Certificate[] certificates = X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias));
            DefaultMutableTreeNode certificatesNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.Certificates"));
            keyPairNode.add(certificatesNode);
            for (int i = 0; i < certificates.length; ++i) {
                X509Certificate certificate = certificates[i];
                DefaultMutableTreeNode certificateNode = new DefaultMutableTreeNode(X509CertUtil.getShortName(certificate));
                certificatesNode.add(certificateNode);
                this.populateCertificateNode(certificateNode, certificate);
            }
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createPrivateKeyNodes(DefaultMutableTreeNode parentNode, String alias) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            Password password = this.getEntryPassword(alias);
            if (password == null) {
                DefaultMutableTreeNode privateKeyNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.PrivateKey"));
                parentNode.add(privateKeyNode);
                DefaultMutableTreeNode lockedNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.Locked"));
                privateKeyNode.add(lockedNode);
                return;
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            this.createPrivateKeyNodes(parentNode, privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createPrivateKeyNodes(DefaultMutableTreeNode parentNode, PrivateKey privateKey) throws CryptoException {
        DefaultMutableTreeNode privateKeyNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.PrivateKey"));
        parentNode.add(privateKeyNode);
        this.currentState.getKeyStore();
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(privateKey);
        String keyAlg = keyInfo.getAlgorithm();
        privateKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Algorithm"), keyAlg)));
        Integer keySize = keyInfo.getSize();
        if (keySize != null) {
            privateKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "" + keyInfo.getSize())));
        } else {
            privateKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "?")));
        }
        String keyFormat = privateKey.getFormat();
        privateKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Format"), keyFormat)));
        byte[] encodedKey = privateKey.getEncoded();
        String keyEncoded = encodedKey != null ? "0x" + new BigInteger(1, privateKey.getEncoded()).toString(16).toUpperCase() : "*****";
        privateKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Encoded"), keyEncoded)));
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privateKey;
            String publicExponent = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PublicExponent"), "0x" + rsaPrivateKey.getPublicExponent().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(publicExponent));
            String modulus = MessageFormat.format(res.getString("DProperties.properties.private.rsa.Modulus"), "0x" + rsaPrivateKey.getModulus().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(modulus));
            String primeP = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PrimeP"), "0x" + rsaPrivateKey.getPrimeP().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeP));
            String primeQ = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PrimeQ"), "0x" + rsaPrivateKey.getPrimeQ().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeQ));
            String primeExponentP = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PrimeExponentP"), "0x" + rsaPrivateKey.getPrimeExponentP().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeExponentP));
            String primeExponentQ = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PrimeExponentQ"), "0x" + rsaPrivateKey.getPrimeExponentQ().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeExponentQ));
            String crtCoefficient = MessageFormat.format(res.getString("DProperties.properties.private.rsa.CrtCoefficient"), "0x" + rsaPrivateKey.getCrtCoefficient().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(crtCoefficient));
            String privateExponent = MessageFormat.format(res.getString("DProperties.properties.private.rsa.PrivateExponent"), "0x" + rsaPrivateKey.getPrivateExponent().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(privateExponent));
        } else if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
            DSAParams dsaParams = dsaPrivateKey.getParams();
            String primeModulusP = MessageFormat.format(res.getString("DProperties.properties.private.dsa.PrimeModulusP"), "0x" + dsaParams.getP().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeModulusP));
            String primeQ = MessageFormat.format(res.getString("DProperties.properties.private.dsa.PrimeQ"), "0x" + dsaParams.getQ().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(primeQ));
            String generatorG = MessageFormat.format(res.getString("DProperties.properties.private.dsa.GeneratorG"), "0x" + dsaParams.getG().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(generatorG));
            String secretExponentX = MessageFormat.format(res.getString("DProperties.properties.private.dsa.SecretExponentX"), "0x" + dsaPrivateKey.getX().toString(16).toUpperCase());
            privateKeyNode.add(new DefaultMutableTreeNode(secretExponentX));
        }
    }

    private Password getEntryPassword(String alias) {
        Password password = this.currentState.getEntryPassword(alias);
        return password;
    }

    private void createKeysNodes(DefaultMutableTreeNode parentNode) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            TreeSet<String> aliases = this.getAliasesInAlphaOrder();
            DefaultMutableTreeNode keysNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.Keys"));
            parentNode.add(keysNode);
            boolean keysPresent = false;
            for (String alias : aliases) {
                if (!KeyStoreUtil.isKeyEntry(alias, keyStore)) continue;
                this.createKeyNodes(keysNode, alias);
                keysPresent = true;
            }
            if (!keysPresent) {
                DefaultMutableTreeNode emptyKeyNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.None"));
                keysNode.add(emptyKeyNode);
            }
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createKeyNodes(DefaultMutableTreeNode parentNode, String alias) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            DefaultMutableTreeNode keyNode = new DefaultMutableTreeNode(alias);
            parentNode.add(keyNode);
            this.createLastModifiedNode(keyNode, alias);
            Password password = this.getEntryPassword(alias);
            if (password == null) {
                DefaultMutableTreeNode lockedNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.Locked"));
                keyNode.add(lockedNode);
                return;
            }
            Key key = keyStore.getKey(alias, password.toCharArray());
            if (key instanceof PublicKey) {
                this.createPublicKeyNodes(keyNode, (PublicKey)key);
            } else if (key instanceof PrivateKey) {
                this.createPrivateKeyNodes(keyNode, (PrivateKey)key);
            } else if (key instanceof SecretKey) {
                this.createSecretKeyNodes(keyNode, (SecretKey)key);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), ex);
        }
    }

    private void createSecretKeyNodes(DefaultMutableTreeNode parentNode, SecretKey secretKey) {
        DefaultMutableTreeNode secretKeyNode = new DefaultMutableTreeNode(res.getString("DProperties.properties.SecretKey"));
        parentNode.add(secretKeyNode);
        KeyInfo keyInfo = SecretKeyUtil.getKeyInfo(secretKey);
        String keyAlg = keyInfo.getAlgorithm();
        SecretKeyType secretKeyType = SecretKeyType.resolveJce(keyAlg);
        if (secretKeyType != null) {
            keyAlg = secretKeyType.friendly();
        }
        secretKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Algorithm"), keyAlg)));
        Integer keySize = keyInfo.getSize();
        if (keySize != null) {
            secretKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "" + keyInfo.getSize())));
        } else {
            secretKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.KeySize"), "?")));
        }
        String keyFormat = secretKey.getFormat();
        secretKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Format"), keyFormat)));
        String keyEncoded = "0x" + new BigInteger(1, secretKey.getEncoded()).toString(16).toUpperCase();
        secretKeyNode.add(new DefaultMutableTreeNode(MessageFormat.format(res.getString("DProperties.properties.Encoded"), keyEncoded)));
    }

    private void createLastModifiedNode(DefaultMutableTreeNode parentNode, String alias) throws CryptoException {
        try {
            KeyStore keyStore = this.currentState.getKeyStore();
            if (KeyStoreType.resolveJce(keyStore.getType()) != KeyStoreType.PKCS12) {
                String lastModified = MessageFormat.format(res.getString("DProperties.properties.LastModified"), StringUtils.formatDate(keyStore.getCreationDate(alias)));
                parentNode.add(new DefaultMutableTreeNode(lastModified));
            }
        }
        catch (ProviderException keyStore) {
        }
        catch (KeyStoreException e) {
            throw new CryptoException(res.getString("DProperties.NoGetProperties.exception.message"), e);
        }
    }

    private void copyPressed() {
        String properties = this.getNodeContents((TreeNode)this.jtrProperties.getModel().getRoot(), 0);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(properties);
        clipboard.setContents(copy, copy);
    }

    private void expandTwoLevels(TreePath treePath) {
        if (treePath.getPathCount() > 2) {
            return;
        }
        TreeNode node = (TreeNode)treePath.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumChildren = node.children();
            while (enumChildren.hasMoreElements()) {
                TreeNode subNode = enumChildren.nextElement();
                TreePath path = treePath.pathByAddingChild(subNode);
                this.expandTwoLevels(path);
            }
        }
        this.jtrProperties.expandPath(treePath);
    }

    private String getNodeContents(TreeNode node, int level) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.INDENT.toString(level));
        strBuff.append(node.toString().trim());
        strBuff.append(NEWLINE);
        for (int i = 0; i < node.getChildCount(); ++i) {
            strBuff.append(this.getNodeContents(node.getChildAt(i), level + 1));
        }
        return strBuff.toString();
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

