/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.kse.ApplicationSettings;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.KseFrame;
import org.kse.gui.PlatformUtil;
import org.kse.gui.actions.ExportTrustedCertificateAction;
import org.kse.gui.actions.ImportTrustedCertificateAction;
import org.kse.gui.crypto.JCertificateFingerprint;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.dialogs.CertificateTreeCellRend;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewPem;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.dialogs.extensions.DViewExtensions;
import org.kse.gui.error.DError;
import org.kse.utilities.StringUtils;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewCertificate
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    public static int NONE = 0;
    public static int IMPORT = 1;
    public static int EXPORT = 2;
    public static int IMPORT_EXPORT = 3;
    private int importExport = 0;
    private KseFrame kseFrame;
    private JPanel jpCertificates;
    private JPanel jpHierarchy;
    private JLabel jlHierarchy;
    private JTree jtrHierarchy;
    private JScrollPane jspHierarchy;
    private JPanel jpDetail;
    private JLabel jlVersion;
    private JTextField jtfVersion;
    private JLabel jlSubject;
    private JDistinguishedName jdnSubject;
    private JLabel jlIssuer;
    private JDistinguishedName jdnIssuer;
    private JLabel jlSerialNumber;
    private JTextField jtfSerialNumber;
    private JLabel jlValidFrom;
    private JTextField jtfValidFrom;
    private JLabel jlValidUntil;
    private JTextField jtfValidUntil;
    private JLabel jlPublicKey;
    private JPanel jpPublicKey;
    private JTextField jtfPublicKey;
    private JButton jbViewPublicKeyDetails;
    private JLabel jlSignatureAlgorithm;
    private JTextField jtfSignatureAlgorithm;
    private JLabel jlFingerprint;
    private JCertificateFingerprint jcfFingerprint;
    private JPanel jpButtons;
    private JButton jbExtensions;
    private JButton jbPem;
    private JButton jbAsn1;
    private JButton jbImport;
    private JButton jbExport;
    private JPanel jpOK;
    private JButton jbOK;

    public DViewCertificate(Window parent, String title, X509Certificate[] certs, KseFrame kseFrame, int importExport) throws CryptoException {
        super(parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.kseFrame = kseFrame;
        this.importExport = importExport;
        this.initComponents(certs);
    }

    private void initComponents(X509Certificate[] certs) throws CryptoException {
        this.jlHierarchy = new JLabel(res.getString("DViewCertificate.jlHierarchy.text"));
        this.jtrHierarchy = new JTree(this.createCertificateNodes(certs));
        this.jtrHierarchy.setRowHeight(Math.max(18, this.jtrHierarchy.getRowHeight()));
        this.jtrHierarchy.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.jtrHierarchy);
        this.jtrHierarchy.setCellRenderer(new CertificateTreeCellRend());
        this.jtrHierarchy.setRootVisible(false);
        TreeNode topNode = (TreeNode)this.jtrHierarchy.getModel().getRoot();
        this.expandTree(this.jtrHierarchy, new TreePath(topNode));
        this.jtrHierarchy.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.populateDetails();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jspHierarchy = PlatformUtil.createScrollPane(this.jtrHierarchy, 20, 30);
        this.jspHierarchy.setPreferredSize(new Dimension(100, 75));
        this.jpHierarchy = new JPanel(new BorderLayout(5, 5));
        this.jpHierarchy.add((Component)this.jlHierarchy, "North");
        this.jpHierarchy.add((Component)this.jspHierarchy, "Center");
        this.jpHierarchy.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 1;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcCtrl = new GridBagConstraints();
        gbcCtrl.gridx = 1;
        gbcCtrl.gridwidth = 1;
        gbcCtrl.gridheight = 1;
        gbcCtrl.insets = new Insets(5, 5, 5, 5);
        gbcCtrl.anchor = 17;
        this.jlVersion = new JLabel(res.getString("DViewCertificate.jlVersion.text"));
        GridBagConstraints gbc_jlVersion = (GridBagConstraints)gbcLbl.clone();
        gbc_jlVersion.gridy = 0;
        this.jtfVersion = new JTextField(3);
        this.jtfVersion.setEditable(false);
        this.jtfVersion.setToolTipText(res.getString("DViewCertificate.jtfVersion.tooltip"));
        GridBagConstraints gbc_jtfVersion = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfVersion.gridy = 0;
        this.jlSubject = new JLabel(res.getString("DViewCertificate.jlSubject.text"));
        GridBagConstraints gbc_jlSubject = (GridBagConstraints)gbcLbl.clone();
        gbc_jlSubject.gridy = 1;
        this.jdnSubject = new JDistinguishedName(res.getString("DViewCertificate.Subject.Title"), 40, false);
        this.jdnSubject.setToolTipText(res.getString("DViewCertificate.jdnSubject.tooltip"));
        GridBagConstraints gbc_jdnSubject = (GridBagConstraints)gbcCtrl.clone();
        gbc_jdnSubject.gridy = 1;
        this.jlIssuer = new JLabel(res.getString("DViewCertificate.jlIssuer.text"));
        GridBagConstraints gbc_jlIssuer = (GridBagConstraints)gbcLbl.clone();
        gbc_jlIssuer.gridy = 2;
        this.jdnIssuer = new JDistinguishedName(res.getString("DViewCertificate.Issuer.Title"), 40, false);
        this.jdnIssuer.setToolTipText(res.getString("DViewCertificate.jdnIssuer.tooltip"));
        GridBagConstraints gbc_jdnIssuer = (GridBagConstraints)gbcCtrl.clone();
        gbc_jdnIssuer.gridy = 2;
        this.jlSerialNumber = new JLabel(res.getString("DViewCertificate.jlSerialNumber.text"));
        GridBagConstraints gbc_jlSerialNumber = (GridBagConstraints)gbcLbl.clone();
        gbc_jlSerialNumber.gridy = 3;
        this.jtfSerialNumber = new JTextField(30);
        this.jtfSerialNumber.setEditable(false);
        this.jtfSerialNumber.setToolTipText(res.getString("DViewCertificate.jtfSerialNumber.tooltip"));
        GridBagConstraints gbc_jtfSerialNumber = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfSerialNumber.gridy = 3;
        this.jlValidFrom = new JLabel(res.getString("DViewCertificate.jlValidFrom.text"));
        GridBagConstraints gbc_jlValidFrom = (GridBagConstraints)gbcLbl.clone();
        gbc_jlValidFrom.gridy = 4;
        this.jtfValidFrom = new JTextField(30);
        this.jtfValidFrom.setEditable(false);
        this.jtfValidFrom.setToolTipText(res.getString("DViewCertificate.jtfValidFrom.tooltip"));
        GridBagConstraints gbc_jtfValidFrom = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfValidFrom.gridy = 4;
        this.jlValidUntil = new JLabel(res.getString("DViewCertificate.jlValidUntil.text"));
        GridBagConstraints gbc_jlValidUntil = (GridBagConstraints)gbcLbl.clone();
        gbc_jlValidUntil.gridy = 5;
        this.jtfValidUntil = new JTextField(30);
        this.jtfValidUntil.setEditable(false);
        this.jtfValidUntil.setToolTipText(res.getString("DViewCertificate.jtfValidUntil.tooltip"));
        GridBagConstraints gbc_jtfValidUntil = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfValidUntil.gridy = 5;
        this.jlPublicKey = new JLabel(res.getString("DViewCertificate.jlPublicKey.text"));
        GridBagConstraints gbc_jlPublicKey = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPublicKey.gridy = 6;
        this.jtfPublicKey = new JTextField(15);
        this.jtfPublicKey.setEditable(false);
        this.jtfPublicKey.setToolTipText(res.getString("DViewCertificate.jtfPublicKey.tooltip"));
        this.jbViewPublicKeyDetails = new JButton();
        this.jbViewPublicKeyDetails.setToolTipText(res.getString("DViewCertificate.jbViewPublicKeyDetails.tooltip"));
        this.jbViewPublicKeyDetails.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/viewpubkey.png"))));
        this.jbViewPublicKeyDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.pubKeyDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jpPublicKey = new JPanel(new GridBagLayout());
        GridBagConstraints gbc_jpPublicKey = (GridBagConstraints)gbcCtrl.clone();
        gbc_jpPublicKey.gridy = 6;
        GridBagConstraints gbc_jtfPublicKey = new GridBagConstraints();
        gbc_jtfPublicKey.gridwidth = 1;
        gbc_jtfPublicKey.gridheight = 1;
        gbc_jtfPublicKey.gridx = 0;
        gbc_jtfPublicKey.gridy = 0;
        gbc_jtfPublicKey.insets = new Insets(0, 0, 0, 5);
        GridBagConstraints gbc_jbViewPublicKeyDetails = new GridBagConstraints();
        gbc_jbViewPublicKeyDetails.gridwidth = 1;
        gbc_jbViewPublicKeyDetails.gridheight = 1;
        gbc_jbViewPublicKeyDetails.gridx = 1;
        gbc_jbViewPublicKeyDetails.gridy = 0;
        gbc_jbViewPublicKeyDetails.insets = new Insets(0, 5, 0, 0);
        this.jpPublicKey.add((Component)this.jtfPublicKey, gbc_jtfPublicKey);
        this.jpPublicKey.add((Component)this.jbViewPublicKeyDetails, gbc_jbViewPublicKeyDetails);
        this.jlSignatureAlgorithm = new JLabel(res.getString("DViewCertificate.jlSignatureAlgorithm.text"));
        GridBagConstraints gbc_jlSignatureAlgorithm = (GridBagConstraints)gbcLbl.clone();
        gbc_jlSignatureAlgorithm.gridy = 7;
        this.jtfSignatureAlgorithm = new JTextField(15);
        this.jtfSignatureAlgorithm.setEditable(false);
        this.jtfSignatureAlgorithm.setToolTipText(res.getString("DViewCertificate.jtfSignatureAlgorithm.tooltip"));
        GridBagConstraints gbc_jtfSignatureAlgorithm = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfSignatureAlgorithm.gridy = 7;
        this.jlFingerprint = new JLabel(res.getString("DViewCertificate.jlFingerprint.text"));
        GridBagConstraints gbc_jlFingerprint = (GridBagConstraints)gbcLbl.clone();
        gbc_jlFingerprint.gridy = 8;
        this.jcfFingerprint = new JCertificateFingerprint(30);
        GridBagConstraints gbc_jcfFingerprint = (GridBagConstraints)gbcCtrl.clone();
        gbc_jcfFingerprint.gridy = 8;
        this.jbExtensions = new JButton(res.getString("DViewCertificate.jbExtensions.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExtensions, res.getString("DViewCertificate.jbExtensions.mnemonic").charAt(0));
        this.jbExtensions.setToolTipText(res.getString("DViewCertificate.jbExtensions.tooltip"));
        this.jbExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.extensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jbPem = new JButton(res.getString("DViewCertificate.jbPem.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPem, res.getString("DViewCertificate.jbPem.mnemonic").charAt(0));
        this.jbPem.setToolTipText(res.getString("DViewCertificate.jbPem.tooltip"));
        this.jbPem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.pemEncodingPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jbAsn1 = new JButton(res.getString("DViewCertificate.jbAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbAsn1, res.getString("DViewCertificate.jbAsn1.mnemonic").charAt(0));
        this.jbAsn1.setToolTipText(res.getString("DViewCertificate.jbAsn1.tooltip"));
        this.jbAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jbImport = new JButton(res.getString("DViewCertificate.jbImportExport.import.text"));
        this.jbImport.setToolTipText(res.getString("DViewCertificate.jbImportExport.import.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbImport, res.getString("DViewCertificate.jbImport.mnemonic").charAt(0));
        this.jbImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.importPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jbExport = new JButton(res.getString("DViewCertificate.jbImportExport.export.text"));
        this.jbExport.setToolTipText(res.getString("DViewCertificate.jbImportExport.export.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DViewCertificate.jbExport.mnemonic").charAt(0));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificate.this);
                    DViewCertificate.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificate.this);
                }
            }
        });
        this.jpButtons = new JPanel();
        if (this.importExport == IMPORT || this.importExport == IMPORT_EXPORT) {
            this.jpButtons.add(this.jbImport);
        }
        if (this.importExport == EXPORT || this.importExport == IMPORT_EXPORT) {
            this.jpButtons.add(this.jbExport);
        }
        this.jpButtons.add(this.jbExtensions);
        this.jpButtons.add(this.jbPem);
        this.jpButtons.add(this.jbAsn1);
        GridBagConstraints gbc_jpButtons = new GridBagConstraints();
        gbc_jpButtons.gridx = 0;
        gbc_jpButtons.gridy = 9;
        gbc_jpButtons.gridwidth = 2;
        gbc_jpButtons.gridheight = 1;
        gbc_jpButtons.anchor = 13;
        this.jpDetail = new JPanel(new GridBagLayout());
        this.jpDetail.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpDetail.add((Component)this.jlVersion, gbc_jlVersion);
        this.jpDetail.add((Component)this.jtfVersion, gbc_jtfVersion);
        this.jpDetail.add((Component)this.jlSubject, gbc_jlSubject);
        this.jpDetail.add((Component)this.jdnSubject, gbc_jdnSubject);
        this.jpDetail.add((Component)this.jlIssuer, gbc_jlIssuer);
        this.jpDetail.add((Component)this.jdnIssuer, gbc_jdnIssuer);
        this.jpDetail.add((Component)this.jlSerialNumber, gbc_jlSerialNumber);
        this.jpDetail.add((Component)this.jtfSerialNumber, gbc_jtfSerialNumber);
        this.jpDetail.add((Component)this.jlValidFrom, gbc_jlValidFrom);
        this.jpDetail.add((Component)this.jtfValidFrom, gbc_jtfValidFrom);
        this.jpDetail.add((Component)this.jlValidUntil, gbc_jlValidUntil);
        this.jpDetail.add((Component)this.jtfValidUntil, gbc_jtfValidUntil);
        this.jpDetail.add((Component)this.jlPublicKey, gbc_jlPublicKey);
        this.jpDetail.add((Component)this.jpPublicKey, gbc_jpPublicKey);
        this.jpDetail.add((Component)this.jlSignatureAlgorithm, gbc_jlSignatureAlgorithm);
        this.jpDetail.add((Component)this.jtfSignatureAlgorithm, gbc_jtfSignatureAlgorithm);
        this.jpDetail.add((Component)this.jlFingerprint, gbc_jlFingerprint);
        this.jpDetail.add((Component)this.jcfFingerprint, gbc_jcfFingerprint);
        this.jpDetail.add((Component)this.jpButtons, gbc_jpButtons);
        this.jpCertificates = new JPanel(new BorderLayout(0, 0));
        this.jpCertificates.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpCertificates.add((Component)this.jpHierarchy, "North");
        this.jpCertificates.add((Component)this.jpDetail, "Center");
        this.jbOK = new JButton(res.getString("DViewCertificate.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewCertificate.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.getContentPane().add((Component)this.jpCertificates, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.jtrHierarchy.setSelectionRow(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewCertificate.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewCertificate.this.jbOK.requestFocus();
            }
        });
    }

    private DefaultMutableTreeNode createCertificateNodes(X509Certificate[] certs) {
        DefaultMutableTreeNode certsNode = new DefaultMutableTreeNode();
        TreeSet<X509Certificate> originalSet = new TreeSet<X509Certificate>(new X509CertificateComparator());
        Collections.addAll(originalSet, certs);
        TreeSet<X509Certificate> certSet = new TreeSet<X509Certificate>(new X509CertificateComparator());
        Collections.addAll(certSet, certs);
        certSet.stream().filter(cert -> !this.isIssuerInSet((X509Certificate)cert, (Set<X509Certificate>)certSet)).forEach(cert -> certsNode.add(new DefaultMutableTreeNode(cert)));
        certSet.removeIf(cert -> !this.isIssuerInSet((X509Certificate)cert, (Set<X509Certificate>)originalSet));
        certSet.stream().filter(X509CertUtil::isCertificateSelfSigned).forEach(cert -> certsNode.add(new DefaultMutableTreeNode(cert)));
        certSet.removeIf(X509CertUtil::isCertificateSelfSigned);
        while (!certSet.isEmpty()) {
            ArrayList<X509Certificate> toBeRemoved = new ArrayList<X509Certificate>();
            for (X509Certificate cert2 : certSet) {
                DefaultMutableTreeNode issuerNode = this.findIssuer(cert2, certsNode);
                if (issuerNode == null) continue;
                issuerNode.add(new DefaultMutableTreeNode(cert2));
                toBeRemoved.add(cert2);
            }
            certSet.removeAll(toBeRemoved);
        }
        return certsNode;
    }

    private DefaultMutableTreeNode findIssuer(X509Certificate cert, DefaultMutableTreeNode node) {
        if (cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
            return null;
        }
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof X509Certificate) {
            X509Certificate nodeCert = (X509Certificate)nodeObj;
            if (cert.getIssuerX500Principal().equals(nodeCert.getSubjectX500Principal())) {
                return node;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode issuerNode = this.findIssuer(cert, (DefaultMutableTreeNode)node.getChildAt(i));
            if (issuerNode == null) continue;
            return issuerNode;
        }
        return null;
    }

    private boolean isIssuerInSet(X509Certificate cert, Set<X509Certificate> certSet) {
        if (cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
            return false;
        }
        for (X509Certificate certToTest : certSet) {
            if (!cert.getIssuerX500Principal().equals(certToTest.getSubjectX500Principal())) continue;
            return true;
        }
        return false;
    }

    private void expandTree(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumNodes = node.children();
            while (enumNodes.hasMoreElements()) {
                TreeNode subNode = enumNodes.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                this.expandTree(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private X509Certificate getSelectedCertificate() {
        TreePath[] selections = this.jtrHierarchy.getSelectionPaths();
        if (selections == null) {
            return null;
        }
        return (X509Certificate)((DefaultMutableTreeNode)selections[0].getLastPathComponent()).getUserObject();
    }

    private void populateDetails() {
        X509Certificate cert = this.getSelectedCertificate();
        if (cert == null) {
            this.jdnSubject.setEnabled(false);
            this.jdnIssuer.setEnabled(false);
            this.jbViewPublicKeyDetails.setEnabled(false);
            this.jcfFingerprint.setEnabled(false);
            this.jbExtensions.setEnabled(false);
            this.jbPem.setEnabled(false);
            this.jbAsn1.setEnabled(false);
            this.jtfVersion.setText("");
            this.jdnSubject.setDistinguishedName(null);
            this.jdnIssuer.setDistinguishedName(null);
            this.jtfSerialNumber.setText("");
            this.jtfValidFrom.setText("");
            this.jtfValidUntil.setText("");
            this.jtfPublicKey.setText("");
            this.jtfSignatureAlgorithm.setText("");
            this.jcfFingerprint.setEncodedCertificate(null);
        } else {
            this.jdnSubject.setEnabled(true);
            this.jdnIssuer.setEnabled(true);
            this.jbViewPublicKeyDetails.setEnabled(true);
            this.jbExtensions.setEnabled(true);
            this.jbPem.setEnabled(true);
            this.jbAsn1.setEnabled(true);
            try {
                byte[] encodedCertificate;
                Date currentDate = new Date();
                Date startDate = cert.getNotBefore();
                Date endDate = cert.getNotAfter();
                boolean notYetValid = currentDate.before(startDate);
                boolean noLongerValid = currentDate.after(endDate);
                this.jtfVersion.setText(Integer.toString(cert.getVersion()));
                this.jtfVersion.setCaretPosition(0);
                this.jdnSubject.setDistinguishedName(X500NameUtils.x500PrincipalToX500Name(cert.getSubjectX500Principal()));
                this.jdnIssuer.setDistinguishedName(X500NameUtils.x500PrincipalToX500Name(cert.getIssuerX500Principal()));
                this.jtfSerialNumber.setText("0x" + new BigInteger(1, cert.getSerialNumber().toByteArray()).toString(16).toUpperCase());
                this.jtfSerialNumber.setCaretPosition(0);
                this.jtfValidFrom.setText(StringUtils.formatDate(startDate));
                if (notYetValid) {
                    this.jtfValidFrom.setText(MessageFormat.format(res.getString("DViewCertificate.jtfValidFrom.notyetvalid.text"), this.jtfValidFrom.getText()));
                    this.jtfValidFrom.setForeground(Color.red);
                } else {
                    this.jtfValidFrom.setForeground(this.jtfVersion.getForeground());
                }
                this.jtfValidFrom.setCaretPosition(0);
                this.jtfValidUntil.setText(StringUtils.formatDate(endDate));
                if (noLongerValid) {
                    this.jtfValidUntil.setText(MessageFormat.format(res.getString("DViewCertificate.jtfValidUntil.expired.text"), this.jtfValidUntil.getText()));
                    this.jtfValidUntil.setForeground(Color.red);
                } else {
                    this.jtfValidUntil.setForeground(this.jtfVersion.getForeground());
                }
                this.jtfValidUntil.setCaretPosition(0);
                KeyInfo keyInfo = KeyPairUtil.getKeyInfo(cert.getPublicKey());
                this.jtfPublicKey.setText(keyInfo.getAlgorithm());
                Integer keySize = keyInfo.getSize();
                if (keySize != null) {
                    this.jtfPublicKey.setText(MessageFormat.format(res.getString("DViewCertificate.jtfPublicKey.text"), this.jtfPublicKey.getText(), "" + keySize));
                } else {
                    this.jtfPublicKey.setText(MessageFormat.format(res.getString("DViewCertificate.jtfPublicKey.text"), this.jtfPublicKey.getText(), "?"));
                }
                this.jtfPublicKey.setCaretPosition(0);
                this.jtfSignatureAlgorithm.setText(X509CertUtil.getCertificateSignatureAlgorithm(cert));
                this.jtfSignatureAlgorithm.setCaretPosition(0);
                try {
                    encodedCertificate = cert.getEncoded();
                }
                catch (CertificateEncodingException ex) {
                    throw new CryptoException(res.getString("DViewCertificate.NoGetEncodedCert.exception.message"), ex);
                }
                this.jcfFingerprint.setEncodedCertificate(encodedCertificate);
                this.jcfFingerprint.setFingerprintAlg(ApplicationSettings.getInstance().getCertificateFingerprintType());
                Set<String> critExts = cert.getCriticalExtensionOIDs();
                Set<String> nonCritExts = cert.getNonCriticalExtensionOIDs();
                if (critExts != null && critExts.size() != 0 || nonCritExts != null && nonCritExts.size() != 0) {
                    this.jbExtensions.setEnabled(true);
                } else {
                    this.jbExtensions.setEnabled(false);
                }
            }
            catch (CryptoException e) {
                DError.displayError(this, (Throwable)e);
                this.dispose();
            }
        }
    }

    private void pubKeyDetailsPressed() {
        try {
            X509Certificate cert = this.getSelectedCertificate();
            DViewPublicKey dViewPublicKey = new DViewPublicKey(this, res.getString("DViewCertificate.PubKeyDetails.Title"), cert.getPublicKey());
            dViewPublicKey.setLocationRelativeTo(this);
            dViewPublicKey.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void extensionsPressed() {
        X509Certificate cert = this.getSelectedCertificate();
        DViewExtensions dViewExtensions = new DViewExtensions(this, res.getString("DViewCertificate.Extensions.Title"), (X509Extension)cert);
        dViewExtensions.setLocationRelativeTo(this);
        dViewExtensions.setVisible(true);
    }

    private void pemEncodingPressed() {
        X509Certificate cert = this.getSelectedCertificate();
        try {
            DViewPem dViewCertPem = new DViewPem((JDialog)this, res.getString("DViewCertificate.Pem.Title"), cert);
            dViewCertPem.setLocationRelativeTo(this);
            dViewCertPem.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void asn1DumpPressed() {
        X509Certificate cert = this.getSelectedCertificate();
        try {
            DViewAsn1Dump dViewAsn1Dump = new DViewAsn1Dump((JDialog)this, cert);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void importPressed() {
        X509Certificate cert = this.getSelectedCertificate();
        new ImportTrustedCertificateAction(this.kseFrame, cert).actionPerformed(null);
    }

    private void exportPressed() {
        X509Certificate cert = this.getSelectedCertificate();
        new ExportTrustedCertificateAction(this.kseFrame, cert).actionPerformed(null);
    }

    private void okPressed() {
        ApplicationSettings.getInstance().setCertificateFingerprintType(this.jcfFingerprint.getSelectedFingerprintAlg());
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private class X509CertificateComparator
    implements Comparator<X509Certificate> {
        private X509CertificateComparator() {
        }

        @Override
        public int compare(X509Certificate cert1, X509Certificate cert2) {
            if (cert1.equals(cert2)) {
                return 0;
            }
            int i = cert1.getSubjectX500Principal().toString().compareTo(cert2.getSubjectX500Principal().toString());
            if (i != 0) {
                return i;
            }
            i = cert1.getIssuerX500Principal().toString().compareTo(cert2.getIssuerX500Principal().toString());
            if (i != 0) {
                return i;
            }
            return cert1.getSerialNumber().subtract(cert2.getSerialNumber()).intValue();
        }
    }
}

