/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.CryptoException;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.error.DError;

public class DViewKeyPair
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpKeyPairDetails;
    private JButton jbCertificateDetails;
    private JButton jbPrivateKeyDetails;
    private JPanel jpOK;
    private JButton jbOK;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;

    public DViewKeyPair(JFrame parent, String title, Dialog.ModalityType modality, PrivateKey privateKey, X509Certificate[] certificateChain) {
        super((Window)parent, title, modality);
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.initComponents();
    }

    public DViewKeyPair(JDialog parent, String title, PrivateKey privateKey, X509Certificate[] certificateChain) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.initComponents();
    }

    private void initComponents() {
        this.jbPrivateKeyDetails = new JButton(res.getString("DViewKeyPair.jbPrivateKeyDetails.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPrivateKeyDetails, res.getString("DViewKeyPair.jbPrivateKeyDetails.mnemonic").charAt(0));
        this.jbPrivateKeyDetails.setToolTipText(res.getString("DViewKeyPair.jbPrivateKeyDetails.tooltip"));
        this.jbPrivateKeyDetails.setEnabled(true);
        this.jbPrivateKeyDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewKeyPair.this);
                    DViewKeyPair.this.privateKeyDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewKeyPair.this);
                }
            }
        });
        this.jbCertificateDetails = new JButton(res.getString("DViewKeyPair.jbCertificateDetails.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCertificateDetails, res.getString("DViewKeyPair.jbCertificateDetails.mnemonic").charAt(0));
        this.jbCertificateDetails.setToolTipText(res.getString("DViewKeyPair.jbCertificateDetails.tooltip"));
        this.jbCertificateDetails.setEnabled(true);
        this.jbCertificateDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewKeyPair.this);
                    DViewKeyPair.this.certificateDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewKeyPair.this);
                }
            }
        });
        this.jpKeyPairDetails = new JPanel(new FlowLayout(0));
        this.jpKeyPairDetails.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpKeyPairDetails.add(this.jbPrivateKeyDetails);
        this.jpKeyPairDetails.add(this.jbCertificateDetails);
        this.jbOK = new JButton(res.getString("DViewCertificate.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewKeyPair.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpKeyPairDetails, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewKeyPair.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewKeyPair.this.jbOK.requestFocus();
            }
        });
    }

    private void privateKeyDetailsPressed() {
        try {
            DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this, res.getString("DViewKeyPair.ViewPrivateKeyDetails.Title"), this.privateKey);
            dViewPrivateKey.setLocationRelativeTo(this);
            dViewPrivateKey.setVisible(true);
        }
        catch (CryptoException ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private void certificateDetailsPressed() {
        try {
            DViewCertificate dViewCertificate = new DViewCertificate(this, res.getString("DViewKeyPair.ViewCertificateDetails.Title"), this.certificateChain, null, DViewCertificate.NONE);
            dViewCertificate.setLocationRelativeTo(this);
            dViewCertificate.setVisible(true);
        }
        catch (CryptoException ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

