/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.math.BigInteger;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class RevokedCertsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private String[] columnNames = new String[2];
    private Object[][] data;

    public RevokedCertsTableModel() {
        this.columnNames[0] = res.getString("RevokedCertsTableModel.SerialNumberColumn");
        this.columnNames[1] = res.getString("RevokedCertsTableModel.RevocationDateColumn");
        this.data = new Object[0][0];
    }

    public void load(X509CRLEntry[] revokedCerts) {
        int i;
        TreeMap<BigInteger, X509CRLEntry> sortedRevokedCerts = new TreeMap<BigInteger, X509CRLEntry>();
        for (i = 0; i < revokedCerts.length; ++i) {
            sortedRevokedCerts.put(revokedCerts[i].getSerialNumber(), revokedCerts[i]);
        }
        this.data = new Object[sortedRevokedCerts.size()][2];
        i = 0;
        Iterator itr = sortedRevokedCerts.entrySet().iterator();
        while (itr.hasNext()) {
            X509CRLEntry x509CrlEntry = (X509CRLEntry)itr.next().getValue();
            this.data[i][0] = x509CrlEntry.getSerialNumber();
            this.data[i][1] = x509CrlEntry.getRevocationDate();
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return BigInteger.class;
        }
        return Date.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

