/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JKeyIdentifier;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DSubjectKeyIdentifier
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpSubjectKeyIdentifier;
    private JLabel jlKeyIdentifier;
    private JKeyIdentifier jkiKeyIdentifier;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;
    private PublicKey subjectPublicKey;

    public DSubjectKeyIdentifier(JDialog parent, PublicKey subjectPublicKey) {
        super(parent);
        this.setTitle(res.getString("DSubjectKeyIdentifier.Title"));
        this.subjectPublicKey = subjectPublicKey;
        this.initComponents();
    }

    public DSubjectKeyIdentifier(JDialog parent, byte[] value, PublicKey subjectPublicKey) throws IOException {
        super(parent);
        this.setTitle(res.getString("DSubjectKeyIdentifier.Title"));
        this.subjectPublicKey = subjectPublicKey;
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlKeyIdentifier = new JLabel(res.getString("DSubjectKeyIdentifier.jlKeyIdentifer.text"));
        this.jkiKeyIdentifier = new JKeyIdentifier(res.getString("DSubjectKeyIdentifier.KeyIdentifier.Title"), this.subjectPublicKey);
        this.jpSubjectKeyIdentifier = new JPanel(new BorderLayout(5, 5));
        this.jpSubjectKeyIdentifier.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpSubjectKeyIdentifier.add((Component)this.jlKeyIdentifier, "West");
        this.jpSubjectKeyIdentifier.add((Component)this.jkiKeyIdentifier, "Center");
        this.jbOK = new JButton(res.getString("DSubjectKeyIdentifier.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectKeyIdentifier.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DSubjectKeyIdentifier.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectKeyIdentifier.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSubjectKeyIdentifier.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpSubjectKeyIdentifier, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSubjectKeyIdentifier.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)value);
        this.jkiKeyIdentifier.setKeyIdentifier(subjectKeyIdentifier.getKeyIdentifier());
    }

    private void okPressed() {
        byte[] keyIdentifier = this.jkiKeyIdentifier.getKeyIdentifier();
        if (keyIdentifier == null) {
            JOptionPane.showMessageDialog(this, res.getString("DSubjectKeyIdentifier.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = new SubjectKeyIdentifier(keyIdentifier);
        try {
            this.value = subjectKeyIdentifier.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

