/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.Password;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.FileNameUtil;

public class DExportKeyPair
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlFormat;
    private JRadioButton jrbFormatPkcs12;
    private JRadioButton jrbFormatPEM;
    private JLabel jlPassword;
    private JComponent jpfPassword;
    private JLabel jlConfirmPassword;
    private JPasswordField jpfConfirmPassword;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private PasswordQualityConfig passwordQualityConfig;
    private boolean exportSelected = false;
    private File exportFile;
    private Password exportPassword;
    private ExportFormat exportFormat = ExportFormat.PKCS12;

    public DExportKeyPair(JFrame parent, String entryAlias, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        this.jlFormat = new JLabel(res.getString("DExportKeyPair.jlFormat.text"));
        this.jrbFormatPkcs12 = new JRadioButton(res.getString("DExportKeyPair.jrbFormatPkcs12.text"));
        this.jrbFormatPkcs12.setToolTipText(res.getString("DExportKeyPair.jrbFormatPkcs12.tooltip"));
        this.jrbFormatPEM = new JRadioButton(res.getString("DExportKeyPair.jrbFormatPEM.text"));
        this.jrbFormatPEM.setToolTipText(res.getString("DExportKeyPair.jrbFormatPEM.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbFormatPkcs12);
        buttonGroup.add(this.jrbFormatPEM);
        this.jrbFormatPkcs12.setSelected(true);
        this.jlPassword = new JLabel(res.getString("DExportKeyPair.jlPassword.text"));
        this.jpfPassword = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DExportKeyPair.jpqfPassword.tooltip"));
        this.jlConfirmPassword = new JLabel(res.getString("DExportKeyPair.jlConfirmPassword.text"));
        this.jpfConfirmPassword = new JPasswordField(15);
        this.jpfConfirmPassword.setToolTipText(res.getString("DExportKeyPair.jpfConfirmPassword.tooltip"));
        this.jlExportFile = new JLabel(res.getString("DExportKeyPair.jlExportFile.text"));
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportKeyPair.jtfExportFile.tooltip"));
        this.jbBrowse = new JButton(res.getString("DExportKeyPair.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportKeyPair.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportKeyPair.jbBrowse.mnemonic").charAt(0));
        this.jbExport = new JButton(res.getString("DExportKeyPair.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportKeyPair.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportKeyPair.jbExport.tooltip"));
        this.jbCancel = new JButton(res.getString("DExportKeyPair.jbCancel.text"));
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("fill", "[right]unrel[]", "unrel[]unrel[]"));
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jrbFormatPkcs12, "split 2");
        pane.add((Component)this.jrbFormatPEM, "wrap");
        pane.add((Component)this.jlPassword, "");
        pane.add((Component)this.jpfPassword, "wrap");
        pane.add((Component)this.jlConfirmPassword, "");
        pane.add((Component)this.jpfConfirmPassword, "wrap");
        pane.add((Component)this.jlExportFile, "");
        pane.add((Component)this.jtfExportFile, "");
        pane.add((Component)this.jbBrowse, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jrbFormatPkcs12.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportKeyPair.this.jrbFormatPkcs12.isSelected()) {
                    DExportKeyPair.this.updateFileExtension("p12");
                }
            }
        });
        this.jrbFormatPEM.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportKeyPair.this.jrbFormatPEM.isSelected()) {
                    DExportKeyPair.this.updateFileExtension("pem");
                }
            }
        });
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportKeyPair.this);
                    DExportKeyPair.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportKeyPair.this);
                }
            }
        });
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportKeyPair.this);
                    DExportKeyPair.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportKeyPair.this);
                }
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportKeyPair.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportKeyPair.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportKeyPair.this.closeDialog();
            }
        });
        this.setTitle(MessageFormat.format(res.getString("DExportKeyPair.Title"), this.entryAlias));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void updateFileExtension(String newExt) {
        String currentFileName = this.jtfExportFile.getText();
        String newFileName = FileNameUtil.removeExtension(currentFileName) + "." + newExt;
        this.jtfExportFile.setText(newFileName);
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "p12");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public ExportFormat getExportFormat() {
        return this.exportFormat;
    }

    public boolean isExportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public Password getExportPassword() {
        return this.exportPassword;
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getPkcs12FileChooser();
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportKeyPair.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportKeyPair.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        Password firstPassword;
        this.exportFormat = this.jrbFormatPkcs12.isSelected() ? ExportFormat.PKCS12 : ExportFormat.PEM;
        if (this.jpfPassword instanceof JPasswordQualityField) {
            char[] firstPasswordChars = ((JPasswordQualityField)this.jpfPassword).getPassword();
            if (firstPasswordChars == null) {
                JOptionPane.showMessageDialog(this, res.getString("DExportKeyPair.MinimumPasswordQualityNotMet.message"), res.getString("DExportKeyPair.Simple.Title"), 2);
                return;
            }
            firstPassword = new Password(firstPasswordChars);
        } else {
            firstPassword = new Password(((JPasswordField)this.jpfPassword).getPassword());
        }
        Password confirmPassword = new Password(this.jpfConfirmPassword.getPassword());
        if (!firstPassword.equals(confirmPassword)) {
            JOptionPane.showMessageDialog(this, res.getString("DExportKeyPair.PasswordsNoMatch.message"), res.getString("DExportKeyPair.Simple.Title"), 2);
            return;
        }
        this.exportPassword = firstPassword;
        String exportFileStr = this.jtfExportFile.getText().trim();
        if (exportFileStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportKeyPair.ExportFileRequired.message"), res.getString("DExportKeyPair.Simple.Title"), 2);
            return;
        }
        File exportFile = new File(exportFileStr);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportKeyPair.OverWriteExportFile.message"), exportFile), res.getString("DExportKeyPair.Simple.Title"), 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        PasswordQualityConfig pwdQualityConf = new PasswordQualityConfig(false, false, 0);
        DExportKeyPair dialog = new DExportKeyPair(new JFrame(), "alias (test)", pwdQualityConf);
        DialogViewer.run(dialog);
    }

    public static enum ExportFormat {
        PKCS12,
        PEM;

    }
}

