/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.apache.commons.io.FileUtils;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.privatekey.OpenSslPvkUtil;
import org.kse.crypto.privatekey.PrivateKeyEncryptedException;
import org.kse.crypto.privatekey.PrivateKeyPbeNotSupportedException;
import org.kse.crypto.privatekey.PrivateKeyUnencryptedException;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;

public class DImportKeyPairOpenSsl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpKeyPair;
    private JLabel jlEncrypted;
    private JCheckBox jcbEncrypted;
    private JLabel jlPassword;
    private JPasswordField jpfPassword;
    private JLabel jlPrivateKey;
    private JTextField jtfPrivateKeyPath;
    private JButton jbPrivateKeyBrowse;
    private JButton jbPrivateKeyDetails;
    private JLabel jlCertificate;
    private JTextField jtfCertificatePath;
    private JButton jbCertificateBrowse;
    private JButton jbCertificateDetails;
    private JPanel jpButtons;
    private JButton jbImport;
    private JButton jbCancel;
    private PrivateKey privateKey;
    private Certificate[] certificateChain;

    public DImportKeyPairOpenSsl(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlEncrypted = new JLabel(res.getString("DImportKeyPairOpenSsl.jlEncrypted.text"));
        GridBagConstraints gbc_jlEncrypted = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEncrypted.gridy = 0;
        this.jcbEncrypted = new JCheckBox();
        this.jcbEncrypted.setSelected(true);
        this.jcbEncrypted.setToolTipText(res.getString("DImportKeyPairOpenSsl.jcbEncrypted.tooltip"));
        GridBagConstraints gbc_jcbEncrypted = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbEncrypted.gridy = 0;
        this.jlPassword = new JLabel(res.getString("DImportKeyPairOpenSsl.jlPassword.text"));
        GridBagConstraints gbc_jlPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPassword.gridy = 1;
        this.jpfPassword = new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DImportKeyPairOpenSsl.jpfPassword.tooltip"));
        GridBagConstraints gbc_jpfPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfPassword.gridy = 1;
        this.jlPrivateKey = new JLabel(res.getString("DImportKeyPairOpenSsl.jlPrivateKey.text"));
        GridBagConstraints gbc_jlPrivateKey = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPrivateKey.gridy = 2;
        this.jtfPrivateKeyPath = new JTextField(30);
        this.jtfPrivateKeyPath.setToolTipText(res.getString("DImportKeyPairOpenSsl.jtfPrivateKeyPath.tooltip"));
        GridBagConstraints gbc_jtfPrivateKeyPath = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfPrivateKeyPath.gridy = 2;
        gbc_jtfPrivateKeyPath.gridwidth = 6;
        this.jbPrivateKeyBrowse = new JButton(res.getString("DImportKeyPairOpenSsl.jbPrivateKeyBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPrivateKeyBrowse, res.getString("DImportKeyPairOpenSsl.jbPrivateKeyBrowse.mnemonic").charAt(0));
        this.jbPrivateKeyBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairOpenSsl.this);
                    DImportKeyPairOpenSsl.this.privateKeyBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairOpenSsl.this);
                }
            }
        });
        this.jbPrivateKeyBrowse.setToolTipText(res.getString("DImportKeyPairOpenSsl.jbPrivateKeyBrowse.tooltip"));
        GridBagConstraints gbc_jbPrivateKeyBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbPrivateKeyBrowse.gridy = 2;
        gbc_jbPrivateKeyBrowse.gridx = 9;
        this.jbPrivateKeyDetails = new JButton(res.getString("DImportKeyPairOpenSsl.jbPrivateKeyDetails.text"));
        this.jbPrivateKeyDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairOpenSsl.this);
                    DImportKeyPairOpenSsl.this.privateKeyDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairOpenSsl.this);
                }
            }
        });
        PlatformUtil.setMnemonic((AbstractButton)this.jbPrivateKeyDetails, res.getString("DImportKeyPairOpenSsl.jbPrivateKeyDetails.mnemonic").charAt(0));
        this.jbPrivateKeyDetails.setToolTipText(res.getString("DImportKeyPairOpenSsl.jbPrivateKeyDetails.tooltip"));
        GridBagConstraints gbc_jbPrivateKeyDetails = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbPrivateKeyDetails.gridy = 2;
        gbc_jbPrivateKeyDetails.gridx = 12;
        this.jlCertificate = new JLabel(res.getString("DImportKeyPairOpenSsl.jlCertificate.text"));
        GridBagConstraints gbc_jlCertificate = (GridBagConstraints)gbcLbl.clone();
        gbc_jlCertificate.gridy = 3;
        this.jtfCertificatePath = new JTextField(30);
        this.jtfCertificatePath.setToolTipText(res.getString("DImportKeyPairOpenSsl.jtfCertificatePath.tooltip"));
        GridBagConstraints gbc_jtfCertificatePath = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfCertificatePath.gridy = 3;
        gbc_jtfCertificatePath.gridwidth = 6;
        this.jbCertificateBrowse = new JButton(res.getString("DImportKeyPairOpenSsl.jbCertificateBrowse.text"));
        this.jbCertificateBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairOpenSsl.this);
                    DImportKeyPairOpenSsl.this.certificateBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairOpenSsl.this);
                }
            }
        });
        PlatformUtil.setMnemonic((AbstractButton)this.jbCertificateBrowse, res.getString("DImportKeyPairOpenSsl.jbCertificateBrowse.mnemonic").charAt(0));
        this.jbCertificateBrowse.setToolTipText(res.getString("DImportKeyPairOpenSsl.jbCertificateBrowse.tooltip"));
        GridBagConstraints gbc_jbCertificateBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbCertificateBrowse.gridy = 3;
        gbc_jbCertificateBrowse.gridx = 9;
        this.jbCertificateDetails = new JButton(res.getString("DImportKeyPairOpenSsl.jbCertificateDetails.text"));
        this.jbCertificateDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairOpenSsl.this);
                    DImportKeyPairOpenSsl.this.certificateDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairOpenSsl.this);
                }
            }
        });
        PlatformUtil.setMnemonic((AbstractButton)this.jbCertificateDetails, res.getString("DImportKeyPairOpenSsl.jbCertificateDetails.mnemonic").charAt(0));
        this.jbCertificateDetails.setToolTipText(res.getString("DImportKeyPairOpenSsl.jbCertificateDetails.tooltip"));
        GridBagConstraints gbc_jbCertificateDetails = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbCertificateDetails.gridy = 3;
        gbc_jbCertificateDetails.gridx = 12;
        this.jpKeyPair = new JPanel(new GridBagLayout());
        this.jpKeyPair.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpKeyPair.add((Component)this.jlEncrypted, gbc_jlEncrypted);
        this.jpKeyPair.add((Component)this.jcbEncrypted, gbc_jcbEncrypted);
        this.jpKeyPair.add((Component)this.jlPassword, gbc_jlPassword);
        this.jpKeyPair.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.jpKeyPair.add((Component)this.jlPrivateKey, gbc_jlPrivateKey);
        this.jpKeyPair.add((Component)this.jtfPrivateKeyPath, gbc_jtfPrivateKeyPath);
        this.jpKeyPair.add((Component)this.jbPrivateKeyBrowse, gbc_jbPrivateKeyBrowse);
        this.jpKeyPair.add((Component)this.jbPrivateKeyDetails, gbc_jbPrivateKeyDetails);
        this.jpKeyPair.add((Component)this.jlCertificate, gbc_jlCertificate);
        this.jpKeyPair.add((Component)this.jtfCertificatePath, gbc_jtfCertificatePath);
        this.jpKeyPair.add((Component)this.jbCertificateBrowse, gbc_jbCertificateBrowse);
        this.jpKeyPair.add((Component)this.jbCertificateDetails, gbc_jbCertificateDetails);
        this.jcbEncrypted.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DImportKeyPairOpenSsl.this.jcbEncrypted.isSelected()) {
                    DImportKeyPairOpenSsl.this.jpfPassword.setEnabled(true);
                } else {
                    DImportKeyPairOpenSsl.this.jpfPassword.setEnabled(false);
                    DImportKeyPairOpenSsl.this.jpfPassword.setText("");
                }
            }
        });
        this.jbImport = new JButton(res.getString("DImportKeyPairOpenSsl.jbImport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbImport, res.getString("DImportKeyPairOpenSsl.jbImport.mnemonic").charAt(0));
        this.jbImport.setToolTipText(res.getString("DImportKeyPairOpenSsl.jbImport.tooltip"));
        this.jbImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairOpenSsl.this);
                    DImportKeyPairOpenSsl.this.importPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairOpenSsl.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DImportKeyPairOpenSsl.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DImportKeyPairOpenSsl.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DImportKeyPairOpenSsl.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbImport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpKeyPair, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DImportKeyPairOpenSsl.this.closeDialog();
            }
        });
        this.setTitle(res.getString("DImportKeyPairOpenSsl.Title"));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbImport);
        this.pack();
    }

    private void privateKeyBrowsePressed() {
        JFileChooser chooser = FileChooserFactory.getOpenSslPvkFileChooser();
        File currentFile = new File(this.jtfPrivateKeyPath.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DImportKeyPairOpenSsl.ChoosePrivateKey.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DImportKeyPairOpenSsl.PrivateKeyFileChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfPrivateKeyPath.setText(chosenFile.toString());
            this.jtfPrivateKeyPath.setCaretPosition(0);
        }
    }

    private void certificateBrowsePressed() {
        JFileChooser chooser = FileChooserFactory.getCertFileChooser();
        File currentFile = new File(this.jtfCertificatePath.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DImportKeyPairOpenSsl.ChooseCertificate.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DImportKeyPairOpenSsl.CertificateFileChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfCertificatePath.setText(chosenFile.toString());
            this.jtfCertificatePath.setCaretPosition(0);
        }
    }

    private void privateKeyDetailsPressed() {
        try {
            String path = new File(this.jtfPrivateKeyPath.getText()).getName();
            PrivateKey privateKey = this.loadPrivateKey();
            if (privateKey != null) {
                DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.ViewPrivateKeyDetails.Title"), path), privateKey);
                dViewPrivateKey.setLocationRelativeTo(this);
                dViewPrivateKey.setVisible(true);
            }
        }
        catch (CryptoException ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private PrivateKey loadPrivateKey() {
        String privateKeyPath = this.jtfPrivateKeyPath.getText().trim();
        if (privateKeyPath.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DImportKeyPairOpenSsl.PrivateKeyRequired.message"), this.getTitle(), 2);
            return null;
        }
        File privateKeyFile = new File(privateKeyPath);
        try {
            PrivateKey privateKey = null;
            byte[] pvkData = FileUtils.readFileToByteArray((File)privateKeyFile);
            if (!this.jcbEncrypted.isSelected()) {
                privateKey = OpenSslPvkUtil.load(pvkData);
            } else {
                Password password = new Password(this.jpfPassword.getPassword());
                privateKey = OpenSslPvkUtil.loadEncrypted(pvkData, password);
            }
            return privateKey;
        }
        catch (PrivateKeyEncryptedException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.PrivateKeyEncrypted.message"), privateKeyFile), this.getTitle(), 2);
            this.jcbEncrypted.setSelected(true);
            return null;
        }
        catch (PrivateKeyUnencryptedException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.PrivateKeyNotEncrypted.message"), privateKeyFile), this.getTitle(), 2);
            this.jcbEncrypted.setSelected(false);
            return null;
        }
        catch (PrivateKeyPbeNotSupportedException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.PrivateKeyPbeNotSupported.message"), ex.getUnsupportedPbe()), this.getTitle(), 2);
            return null;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoReadFile.message"), privateKeyFile), this.getTitle(), 2);
            return null;
        }
        catch (Exception ex) {
            Problem problem = this.createLoadOpenSslProblem(ex, privateKeyFile);
            DProblem dProblem = new DProblem(this, res.getString("DImportKeyPairOpenSsl.ProblemLoadingOpenSsl.Title"), problem);
            dProblem.setLocationRelativeTo(this);
            dProblem.setVisible(true);
            return null;
        }
    }

    private Problem createLoadOpenSslProblem(Exception exception, File openSslFile) {
        String problemStr = null;
        ArrayList<String> causeList = new ArrayList<String>();
        if (this.jcbEncrypted.isSelected()) {
            problemStr = MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoLoadEncryptedOpenSsl.Problem"), openSslFile.getName());
            causeList.add(res.getString("DImportKeyPairOpenSsl.PasswordIncorrectOpenSsl.Cause"));
        } else {
            problemStr = MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoLoadUnencryptedOpenSsl.Problem"), openSslFile.getName());
        }
        causeList.add(res.getString("DImportKeyPairOpenSsl.NotOpenSsl.Cause"));
        causeList.add(res.getString("DImportKeyPairOpenSsl.CorruptedOpenSsl.Cause"));
        String[] causes = causeList.toArray(new String[causeList.size()]);
        Problem problem = new Problem(problemStr, causes, exception);
        return problem;
    }

    private void certificateDetailsPressed() {
        try {
            X509Certificate[] certs = this.loadCertificates();
            if (certs != null && certs.length != 0) {
                String path = new File(this.jtfCertificatePath.getText()).getName();
                DViewCertificate dViewCertificate = new DViewCertificate(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.ViewCertificateDetails.Title"), path), certs, null, DViewCertificate.NONE);
                dViewCertificate.setLocationRelativeTo(this);
                dViewCertificate.setVisible(true);
            }
        }
        catch (CryptoException ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private X509Certificate[] loadCertificates() {
        String certificatePath = this.jtfCertificatePath.getText().trim();
        if (certificatePath.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DImportKeyPairOpenSsl.CertificateRequired.message"), this.getTitle(), 2);
            return null;
        }
        File certificateFile = new File(certificatePath);
        try {
            byte[] certData = FileUtils.readFileToByteArray((File)certificateFile);
            X509Certificate[] certs = X509CertUtil.loadCertificates(certData);
            if (certs.length == 0) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoCertsFound.message"), certificateFile), this.getTitle(), 2);
            }
            return certs;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoReadFile.message"), certificateFile), this.getTitle(), 2);
            return null;
        }
        catch (Exception ex) {
            Problem problem = this.createLoadCertsProblem(ex, certificateFile);
            DProblem dProblem = new DProblem(this, res.getString("DImportKeyPairOpenSsl.ProblemLoadingCerts.Title"), problem);
            dProblem.setLocationRelativeTo(this);
            dProblem.setVisible(true);
            return null;
        }
    }

    private Problem createLoadCertsProblem(Exception exception, File certsFile) {
        String problemStr = MessageFormat.format(res.getString("DImportKeyPairOpenSsl.NoLoadCerts.Problem"), certsFile.getName());
        String[] causes = new String[]{res.getString("DImportKeyPairOpenSsl.NotCerts.Cause"), res.getString("DImportKeyPairOpenSsl.CorruptedCerts.Cause")};
        Problem problem = new Problem(problemStr, causes, exception);
        return problem;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    private void importPressed() {
        try {
            PrivateKey privateKey = this.loadPrivateKey();
            if (privateKey == null) {
                return;
            }
            X509Certificate[] certs = this.loadCertificates();
            if (certs == null || certs.length == 0) {
                return;
            }
            if (!KeyPairUtil.validKeyPair(privateKey, (certs = X509CertUtil.orderX509CertChain(certs))[0].getPublicKey())) {
                JOptionPane.showMessageDialog(this, res.getString("DImportKeyPairOpenSsl.KeyPairInvalid.message"), this.getTitle(), 2);
                return;
            }
            this.privateKey = privateKey;
            this.certificateChain = certs;
            this.closeDialog();
        }
        catch (Exception ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

