/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnchooser;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class OidDisplayNameMapping {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dnchooser/resources");
    private static final String DC = res.getString("DistinguishedNameChooser.jlDomainComponent.text");
    private static final String SURNAME = res.getString("DistinguishedNameChooser.jlSurname.text");
    private static final String GIVENNAME = res.getString("DistinguishedNameChooser.jlGivenName.text");
    private static final String SN = res.getString("DistinguishedNameChooser.jlSerialNumber.text");
    private static final String E = res.getString("DistinguishedNameChooser.jlEmailAddress.text");
    private static final String C = res.getString("DistinguishedNameChooser.jlCountryCode.text");
    private static final String ST = res.getString("DistinguishedNameChooser.jlStateName.text");
    private static final String L = res.getString("DistinguishedNameChooser.jlLocalityName.text");
    private static final String O = res.getString("DistinguishedNameChooser.jlOrganisationName.text");
    private static final String OU = res.getString("DistinguishedNameChooser.jlOrganisationUnit.text");
    private static final String CN = res.getString("DistinguishedNameChooser.jlCommonName.text");
    private static final String UID = res.getString("DistinguishedNameChooser.jlUserID.text");
    private static Map<String, ASN1ObjectIdentifier> displayNameToOID = new HashMap<String, ASN1ObjectIdentifier>();
    private static Map<String, String> oidToDisplayName;

    public static String[] getDisplayNames() {
        return new String[]{CN, OU, O, L, ST, C, E, SN, GIVENNAME, SURNAME, DC, UID};
    }

    public static ASN1ObjectIdentifier getOidForDisplayName(String displayName) {
        return displayNameToOID.get(displayName);
    }

    public static String getDisplayNameForOid(String oid) {
        String displayName = oidToDisplayName.get(oid);
        if (displayName == null) {
            displayName = oid;
        }
        return displayName;
    }

    private OidDisplayNameMapping() {
    }

    static {
        displayNameToOID.put(CN, BCStyle.CN);
        displayNameToOID.put(OU, BCStyle.OU);
        displayNameToOID.put(O, BCStyle.O);
        displayNameToOID.put(L, BCStyle.L);
        displayNameToOID.put(ST, BCStyle.ST);
        displayNameToOID.put(C, BCStyle.C);
        displayNameToOID.put(E, BCStyle.E);
        displayNameToOID.put(SN, BCStyle.SERIALNUMBER);
        displayNameToOID.put(GIVENNAME, BCStyle.GIVENNAME);
        displayNameToOID.put(SURNAME, BCStyle.SURNAME);
        displayNameToOID.put(DC, BCStyle.DC);
        displayNameToOID.put(UID, BCStyle.UID);
        oidToDisplayName = new HashMap<String, String>();
        oidToDisplayName.put(BCStyle.CN.getId(), CN);
        oidToDisplayName.put(BCStyle.OU.getId(), OU);
        oidToDisplayName.put(BCStyle.O.getId(), O);
        oidToDisplayName.put(BCStyle.L.getId(), L);
        oidToDisplayName.put(BCStyle.ST.getId(), ST);
        oidToDisplayName.put(BCStyle.C.getId(), C);
        oidToDisplayName.put(BCStyle.E.getId(), E);
        oidToDisplayName.put(BCStyle.SERIALNUMBER.getId(), SN);
        oidToDisplayName.put(BCStyle.GIVENNAME.getId(), GIVENNAME);
        oidToDisplayName.put(BCStyle.SURNAME.getId(), SURNAME);
        oidToDisplayName.put(BCStyle.DC.getId(), DC);
        oidToDisplayName.put(BCStyle.UID.getId(), UID);
    }
}

