/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.kse.gui.JEscDialog;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.jar.JarInfoTableCellRend;
import org.kse.gui.jar.JarInfoTableModel;

public class DJarInfo
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/jar/resources");
    private JButton jbOK;
    private JPanel jpOK;
    private JPanel jpJarInfoTable;
    private JScrollPane jspJarInfoTable;
    private JKseTable jtJarInfo;

    public DJarInfo(JFrame parent) throws IOException {
        this(parent, res.getString("DJarInfo.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public DJarInfo(JFrame parent, String title, Dialog.ModalityType modality) throws IOException {
        super((Window)parent, title, modality);
        this.initComponents();
    }

    private void initComponents() throws IOException {
        JarFile[] jarFiles = this.getClassPathJars();
        JarInfoTableModel jiModel = new JarInfoTableModel();
        jiModel.load(jarFiles);
        this.jtJarInfo = new JKseTable(jiModel);
        this.jtJarInfo.setRowMargin(0);
        this.jtJarInfo.getColumnModel().setColumnMargin(0);
        this.jtJarInfo.getTableHeader().setReorderingAllowed(false);
        this.jtJarInfo.setAutoResizeMode(0);
        TableRowSorter<JarInfoTableModel> sorter = new TableRowSorter<JarInfoTableModel>(jiModel);
        this.jtJarInfo.setRowSorter(sorter);
        for (int i = 0; i < this.jtJarInfo.getColumnCount(); ++i) {
            TableColumn column = this.jtJarInfo.getColumnModel().getColumn(i);
            column.setPreferredWidth(150);
            column.setCellRenderer(new JarInfoTableCellRend());
        }
        this.jspJarInfoTable = PlatformUtil.createScrollPane(this.jtJarInfo, 20, 30);
        this.jspJarInfoTable.getViewport().setBackground(this.jtJarInfo.getBackground());
        this.jpJarInfoTable = new JPanel(new BorderLayout(10, 10));
        this.jpJarInfoTable.setPreferredSize(new Dimension(500, 200));
        this.jpJarInfoTable.add((Component)this.jspJarInfoTable, "Center");
        this.jpJarInfoTable.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jbOK = new JButton(res.getString("DJarInfo.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DJarInfo.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.getContentPane().add((Component)this.jpJarInfoTable, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DJarInfo.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DJarInfo.this.jbOK.requestFocus();
            }
        });
    }

    private JarFile[] getClassPathJars() throws IOException {
        Attributes attributes;
        String jarClassPath;
        JarFile jarFile;
        Manifest manifest;
        Vector<JarFile> jars = new Vector<JarFile>();
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer strTok = new StringTokenizer(classPath, pathSeparator);
        while (strTok.hasMoreTokens()) {
            String classPathEntry = strTok.nextToken();
            File file = new File(classPathEntry);
            if (!this.isJarFile(file)) continue;
            jars.add(new JarFile(file));
        }
        if (jars.size() == 1 && (manifest = (jarFile = (JarFile)jars.get(0)).getManifest()) != null && (jarClassPath = (attributes = manifest.getMainAttributes()).getValue("Class-Path")) != null) {
            strTok = new StringTokenizer(jarClassPath, " ");
            while (strTok.hasMoreTokens()) {
                String jarClassPathEntry = strTok.nextToken();
                File file = new File(new File(jarFile.getName()).getParent(), jarClassPathEntry);
                if (!this.isJarFile(file)) continue;
                jars.add(new JarFile(file));
            }
        }
        return jars.toArray(new JarFile[jars.size()]);
    }

    private boolean isJarFile(File file) {
        String name;
        return file.isFile() && ((name = file.getName()).endsWith(".jar") || name.endsWith(".JAR") || name.endsWith(".zip") || name.endsWith(".ZIP"));
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

