/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.oid;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.oid.InvalidObjectIdException;
import org.kse.utilities.oid.ObjectIdUtil;

public class DObjectIdChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/oid/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpObjectId;
    private JLabel jlObjectId;
    private JComboBox<?> jcbFirstArc;
    private JLabel jlFirstPeriod;
    private JComboBox<Integer> jcbSecondArc;
    private JTextField jtfRemainingArcs;
    private JLabel jlSecondPeriod;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private ASN1ObjectIdentifier objectId;

    public DObjectIdChooser(JFrame parent, String title, ASN1ObjectIdentifier objectId) throws InvalidObjectIdException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(objectId);
    }

    public DObjectIdChooser(JDialog parent, String title, ASN1ObjectIdentifier objectId) throws InvalidObjectIdException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(objectId);
    }

    private void initComponents(ASN1ObjectIdentifier objectId) throws InvalidObjectIdException {
        this.jlObjectId = new JLabel(res.getString("DObjectIdChooser.jlObjectId.text"));
        this.jcbFirstArc = new JComboBox<Integer>(new Integer[]{0, 1, 2});
        this.jcbFirstArc.setToolTipText(res.getString("DObjectIdChooser.jcbFirstArc.tooltip"));
        this.jlFirstPeriod = new JLabel(".");
        this.jcbSecondArc = new JComboBox();
        this.jcbSecondArc.setToolTipText(res.getString("DObjectIdChooser.jcbSecondArc.tooltip"));
        this.jlSecondPeriod = new JLabel(".");
        this.jtfRemainingArcs = new JTextField(15);
        this.jtfRemainingArcs.setToolTipText(res.getString("DObjectIdChooser.jtfRemainingArcs.tooltip"));
        this.populateSecondArc();
        this.jcbFirstArc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DObjectIdChooser.this.populateSecondArc();
            }
        });
        this.jpObjectId = new JPanel(new FlowLayout());
        this.jpObjectId.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpObjectId.add(this.jlObjectId);
        this.jpObjectId.add(this.jcbFirstArc);
        this.jpObjectId.add(this.jlFirstPeriod);
        this.jpObjectId.add(this.jcbSecondArc);
        this.jpObjectId.add(this.jlSecondPeriod);
        this.jpObjectId.add(this.jtfRemainingArcs);
        this.jbOK = new JButton(res.getString("DObjectIdChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DObjectIdChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DObjectIdChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DObjectIdChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DObjectIdChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpObjectId);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(objectId);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(ASN1ObjectIdentifier objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            this.populateSecondArc();
        } else {
            ObjectIdUtil.validate(objectId);
            int[] arcs = ObjectIdUtil.extractArcs(objectId);
            this.jcbFirstArc.setSelectedItem(arcs[0]);
            this.jcbSecondArc.setSelectedItem(arcs[1]);
            String remainingArcs = "";
            for (int i = 2; i < arcs.length; ++i) {
                remainingArcs = remainingArcs + arcs[i];
                if (i + 1 >= arcs.length) continue;
                remainingArcs = remainingArcs + ".";
            }
            this.jtfRemainingArcs.setText(remainingArcs);
        }
    }

    private void populateSecondArc() {
        int firstArc = (Integer)this.jcbFirstArc.getSelectedItem();
        int secondArc = this.jcbSecondArc.getSelectedIndex();
        int maxSecondArc = firstArc == 0 || firstArc == 1 ? 39 : 47;
        this.jcbSecondArc.removeAllItems();
        for (int i = 0; i <= maxSecondArc; ++i) {
            this.jcbSecondArc.addItem(i);
        }
        if (secondArc != -1 && secondArc <= maxSecondArc) {
            this.jcbSecondArc.setSelectedIndex(secondArc);
        } else {
            this.jcbSecondArc.setSelectedIndex(0);
        }
    }

    public ASN1ObjectIdentifier getObjectId() {
        return this.objectId;
    }

    private void okPressed() {
        String firstArc = "" + this.jcbFirstArc.getSelectedItem();
        String secondArc = "" + this.jcbSecondArc.getSelectedItem();
        String remainingArcs = this.jtfRemainingArcs.getText().trim();
        try {
            ASN1ObjectIdentifier newObjectId = new ASN1ObjectIdentifier(firstArc + "." + secondArc + "." + remainingArcs);
            ObjectIdUtil.validate(newObjectId);
            this.objectId = newObjectId;
        }
        catch (IllegalArgumentException | InvalidObjectIdException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            return;
        }
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

