/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.oid;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.gui.CursorUtil;
import org.kse.gui.error.DError;
import org.kse.gui.oid.DObjectIdChooser;
import org.kse.utilities.oid.InvalidObjectIdException;
import org.kse.utilities.oid.ObjectIdUtil;

public class JObjectId
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/oid/resources");
    private JTextField jtfObjectId;
    private JButton jbEditObjectId;
    private JButton jbClearObjectId;
    private String title;
    private ASN1ObjectIdentifier objectId;

    public JObjectId(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jtfObjectId = new JTextField(25);
        this.jtfObjectId.setEditable(false);
        GridBagConstraints gbc_jtfObjectId = new GridBagConstraints();
        gbc_jtfObjectId.gridwidth = 1;
        gbc_jtfObjectId.gridheight = 1;
        gbc_jtfObjectId.gridx = 0;
        gbc_jtfObjectId.gridy = 0;
        gbc_jtfObjectId.insets = new Insets(0, 0, 0, 5);
        ImageIcon editIcon = new ImageIcon(this.getClass().getResource("images/edit_object_id.png"));
        this.jbEditObjectId = new JButton(editIcon);
        this.jbEditObjectId.setToolTipText(res.getString("JObjectId.jbEditObjectId.tooltip"));
        this.jbEditObjectId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JObjectId.this);
                    JObjectId.this.editObjectId();
                }
                finally {
                    CursorUtil.setCursorFree(JObjectId.this);
                }
            }
        });
        GridBagConstraints gbc_jbEditObjectId = new GridBagConstraints();
        gbc_jbEditObjectId.gridwidth = 1;
        gbc_jbEditObjectId.gridheight = 1;
        gbc_jbEditObjectId.gridx = 1;
        gbc_jbEditObjectId.gridy = 0;
        gbc_jbEditObjectId.insets = new Insets(0, 0, 0, 5);
        ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_object_id.png"));
        this.jbClearObjectId = new JButton(clearIcon);
        this.jbClearObjectId.setToolTipText(res.getString("JObjectId.jbClearObjectId.tooltip"));
        this.jbClearObjectId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JObjectId.this);
                    JObjectId.this.clearObjectId();
                }
                finally {
                    CursorUtil.setCursorFree(JObjectId.this);
                }
            }
        });
        GridBagConstraints gbc_jbClearObjectId = new GridBagConstraints();
        gbc_jbClearObjectId.gridwidth = 1;
        gbc_jbClearObjectId.gridheight = 1;
        gbc_jbClearObjectId.gridx = 2;
        gbc_jbClearObjectId.gridy = 0;
        gbc_jbClearObjectId.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfObjectId, gbc_jtfObjectId);
        this.add((Component)this.jbEditObjectId, gbc_jbEditObjectId);
        this.add((Component)this.jbClearObjectId, gbc_jbClearObjectId);
        this.populate();
    }

    public ASN1ObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ASN1ObjectIdentifier objectId) {
        this.objectId = objectId;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbEditObjectId.setEnabled(enabled);
        this.jbClearObjectId.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfObjectId.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.objectId != null) {
            this.jtfObjectId.setText(ObjectIdUtil.toString(this.objectId));
            this.jbClearObjectId.setEnabled(true);
        } else {
            this.jtfObjectId.setText("");
            this.jbClearObjectId.setEnabled(false);
        }
        this.jtfObjectId.setCaretPosition(0);
    }

    private void editObjectId() {
        Container container = this.getTopLevelAncestor();
        try {
            DObjectIdChooser dObjectIdChooser = null;
            dObjectIdChooser = container instanceof JDialog ? new DObjectIdChooser((JDialog)container, this.title, this.objectId) : new DObjectIdChooser((JFrame)container, this.title, this.objectId);
            dObjectIdChooser.setLocationRelativeTo(container);
            dObjectIdChooser.setVisible(true);
            ASN1ObjectIdentifier newObjectId = dObjectIdChooser.getObjectId();
            if (newObjectId == null) {
                return;
            }
            this.setObjectId(newObjectId);
        }
        catch (InvalidObjectIdException ex) {
            DError dError = null;
            dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
            dError.setLocationRelativeTo(container);
            dError.setVisible(true);
        }
    }

    private void clearObjectId() {
        this.setObjectId(null);
    }
}

