/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.password;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.Password;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;

public class DChangePassword
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/password/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPassword;
    private JLabel jlOld;
    private JPasswordField jpfOld;
    private JLabel jlFirst;
    private JComponent jpfFirst;
    private JLabel jlConfirm;
    private JPasswordField jpfConfirm;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PasswordQualityConfig passwordQualityConfig;
    private Password newPassword;
    private Password oldPassword;

    public DChangePassword(JFrame parent, Dialog.ModalityType modality, Password oldPassword, PasswordQualityConfig passwordQualityConfig) {
        this(parent, modality, res.getString("DChangePassword.Title"), oldPassword, passwordQualityConfig);
    }

    public DChangePassword(JFrame parent, Dialog.ModalityType modality, String title, Password oldPassword, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, title, modality);
        this.oldPassword = oldPassword;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    public DChangePassword(JDialog parent, Dialog.ModalityType modality, Password oldPassword, PasswordQualityConfig passwordQualityConfig) {
        this(parent, res.getString("DChangePassword.Title"), modality, oldPassword, passwordQualityConfig);
    }

    public DChangePassword(JDialog parent, String title, Dialog.ModalityType modality, Password oldPassword, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, title, modality);
        this.oldPassword = oldPassword;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.jlOld = new JLabel(res.getString("DChangePassword.jlOld.text"));
        GridBagConstraints gbc_jlOld = new GridBagConstraints();
        gbc_jlOld.gridx = 0;
        gbc_jlOld.gridy = 0;
        gbc_jlOld.anchor = 13;
        gbc_jlOld.insets = new Insets(5, 5, 5, 5);
        if (this.oldPassword != null) {
            this.jpfOld = new JPasswordField("1234567890", 15);
            this.jpfOld.setEnabled(false);
        } else {
            this.jpfOld = new JPasswordField(15);
        }
        GridBagConstraints gbc_jpfOld = new GridBagConstraints();
        gbc_jpfOld.gridx = 1;
        gbc_jpfOld.gridy = 0;
        gbc_jpfOld.anchor = 17;
        gbc_jpfOld.insets = new Insets(5, 5, 5, 5);
        this.jlFirst = new JLabel(res.getString("DChangePassword.jlFirst.text"));
        GridBagConstraints gbc_jlFirst = new GridBagConstraints();
        gbc_jlFirst.gridx = 0;
        gbc_jlFirst.gridy = 1;
        gbc_jlFirst.anchor = 13;
        gbc_jlFirst.insets = new Insets(5, 5, 5, 5);
        this.jpfFirst = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        GridBagConstraints gbc_jpqfFirst = new GridBagConstraints();
        gbc_jpqfFirst.gridx = 1;
        gbc_jpqfFirst.gridy = 1;
        gbc_jpqfFirst.anchor = 17;
        gbc_jpqfFirst.insets = new Insets(5, 5, 5, 5);
        this.jlConfirm = new JLabel(res.getString("DChangePassword.jlConfirm.text"));
        GridBagConstraints gbc_jlConfirm = new GridBagConstraints();
        gbc_jlConfirm.gridx = 0;
        gbc_jlConfirm.gridy = 2;
        gbc_jlConfirm.anchor = 13;
        gbc_jlConfirm.insets = new Insets(5, 5, 5, 5);
        this.jpfConfirm = new JPasswordField(15);
        GridBagConstraints gbc_jpfConfirm = new GridBagConstraints();
        gbc_jpfConfirm.gridx = 1;
        gbc_jpfConfirm.gridy = 2;
        gbc_jpfConfirm.anchor = 17;
        gbc_jpfConfirm.insets = new Insets(5, 5, 5, 5);
        this.jpPassword = new JPanel(new GridBagLayout());
        this.jpPassword.add((Component)this.jlOld, gbc_jlOld);
        this.jpPassword.add((Component)this.jpfOld, gbc_jpfOld);
        this.jpPassword.add((Component)this.jlFirst, gbc_jlFirst);
        this.jpPassword.add((Component)this.jpfFirst, gbc_jpqfFirst);
        this.jpPassword.add((Component)this.jlConfirm, gbc_jlConfirm);
        this.jpPassword.add((Component)this.jpfConfirm, gbc_jpfConfirm);
        this.jpPassword.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jbOK = new JButton(res.getString("DChangePassword.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DChangePassword.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DChangePassword.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DChangePassword.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DChangePassword.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().add((Component)this.jpPassword, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DChangePassword.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    public Password getNewPassword() {
        return this.newPassword;
    }

    public Password getOldPassword() {
        return this.oldPassword;
    }

    private boolean checkPassword() {
        Password firstPassword;
        Password oldPassword = new Password(this.jpfOld.getPassword());
        if (this.jpfFirst instanceof JPasswordQualityField) {
            char[] firstPasswordChars = ((JPasswordQualityField)this.jpfFirst).getPassword();
            if (firstPasswordChars == null) {
                JOptionPane.showMessageDialog(this, res.getString("MinimumPasswordQualityNotMet.message"), this.getTitle(), 2);
                return false;
            }
            firstPassword = new Password(firstPasswordChars);
        } else {
            firstPassword = new Password(((JPasswordField)this.jpfFirst).getPassword());
        }
        Password confirmPassword = new Password(this.jpfConfirm.getPassword());
        if (firstPassword.equals(confirmPassword)) {
            this.oldPassword = oldPassword;
            this.newPassword = firstPassword;
            return true;
        }
        JOptionPane.showMessageDialog(this, res.getString("PasswordsNoMatch.message"), this.getTitle(), 2);
        return false;
    }

    private void okPressed() {
        if (this.checkPassword()) {
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

