/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.net;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.kse.utilities.net.ProxyAddress;

public class ManualProxySelector
extends ProxySelector {
    private ProxyAddress httpProxyAddress;
    private ProxyAddress httpsProxyAddress;
    private ProxyAddress ftpProxyAddress;
    private ProxyAddress socksProxyAddress;
    private Proxy httpProxy;
    private Proxy httpsProxy;
    private Proxy ftpProxy;
    private Proxy socksProxy;

    public ManualProxySelector(ProxyAddress httpProxyAddress, ProxyAddress httpsProxyAddress, ProxyAddress ftpProxyAddress, ProxyAddress socksProxyAddress) {
        this.httpProxyAddress = httpProxyAddress;
        this.httpsProxyAddress = httpsProxyAddress;
        this.ftpProxyAddress = ftpProxyAddress;
        this.socksProxyAddress = socksProxyAddress;
    }

    @Override
    public List<Proxy> select(URI uri) {
        this.createProxies();
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        if (uri.getScheme().equals("http") && this.httpProxy != null) {
            proxies.add(this.httpProxy);
        } else if (uri.getScheme().equals("https") && this.httpsProxy != null) {
            proxies.add(this.httpsProxy);
        } else if (uri.getScheme().equals("ftp") && this.ftpProxy != null) {
            proxies.add(this.ftpProxy);
        } else if (this.socksProxy != null) {
            proxies.add(this.socksProxy);
        }
        if (proxies.isEmpty()) {
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    private void createProxies() {
        if (this.httpProxy == null && this.httpsProxy == null && this.ftpProxy == null && this.socksProxy == null) {
            if (this.httpProxyAddress != null) {
                this.httpProxy = new Proxy(Proxy.Type.HTTP, this.httpProxyAddress.getInetSocketAddress());
            }
            if (this.httpsProxyAddress != null) {
                this.httpsProxy = new Proxy(Proxy.Type.HTTP, this.httpsProxyAddress.getInetSocketAddress());
            }
            if (this.ftpProxyAddress != null) {
                this.ftpProxy = new Proxy(Proxy.Type.HTTP, this.ftpProxyAddress.getInetSocketAddress());
            }
            if (this.socksProxyAddress != null) {
                this.socksProxy = new Proxy(Proxy.Type.SOCKS, this.socksProxyAddress.getInetSocketAddress());
            }
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress socketAddress, IOException ioException) {
    }

    public ProxyAddress getHttpProxyAddress() {
        return this.httpProxyAddress;
    }

    public ProxyAddress getHttpsProxyAddress() {
        return this.httpsProxyAddress;
    }

    public ProxyAddress getFtpProxyAddress() {
        return this.ftpProxyAddress;
    }

    public ProxyAddress getSocksProxyAddress() {
        return this.socksProxyAddress;
    }

    public boolean equals(Object object) {
        boolean ftpEquals;
        boolean httpsEquals;
        boolean httpEquals;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ManualProxySelector)) {
            return false;
        }
        ManualProxySelector cmpManualProxySelector = (ManualProxySelector)object;
        ProxyAddress proxyHttpAddress = this.getHttpProxyAddress();
        ProxyAddress cmpHttpProxyAddress = cmpManualProxySelector.getHttpProxyAddress();
        boolean bl = proxyHttpAddress == null ? cmpHttpProxyAddress == null : (httpEquals = proxyHttpAddress.equals(cmpHttpProxyAddress));
        if (!httpEquals) {
            return false;
        }
        ProxyAddress proxyHttpsAddress = this.getHttpsProxyAddress();
        ProxyAddress cmpHttpsProxyAddress = cmpManualProxySelector.getHttpsProxyAddress();
        boolean bl2 = proxyHttpsAddress == null ? cmpHttpsProxyAddress == null : (httpsEquals = proxyHttpsAddress.equals(cmpHttpsProxyAddress));
        if (!httpsEquals) {
            return false;
        }
        ProxyAddress proxyFtpAddress = this.getFtpProxyAddress();
        ProxyAddress cmpFtpProxyAddress = cmpManualProxySelector.getFtpProxyAddress();
        boolean bl3 = proxyFtpAddress == null ? cmpFtpProxyAddress == null : (ftpEquals = proxyFtpAddress.equals(cmpFtpProxyAddress));
        if (!ftpEquals) {
            return false;
        }
        ProxyAddress proxySocksAddress = this.getSocksProxyAddress();
        ProxyAddress cmpSocksProxyAddress = cmpManualProxySelector.getSocksProxyAddress();
        boolean socksEquals = proxySocksAddress == null ? cmpSocksProxyAddress == null : proxySocksAddress.equals(cmpSocksProxyAddress);
        return socksEquals;
    }
}

