/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.os;

public class OperatingSystem {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_VERSION = System.getProperty("os.version");

    private OperatingSystem() {
    }

    public static boolean isWindowsNt4() {
        return OS_NAME.indexOf("Windows NT") > -1 && OS_VERSION.equals("4.0");
    }

    public static boolean isWindows95() {
        return OS_NAME.indexOf("Windows 95") > -1 && OS_VERSION.equals("4.0");
    }

    public static boolean isWindows98() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("4.1");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("4.9");
    }

    public static boolean isWindows2000() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("5.0");
    }

    public static boolean isWindowsXp() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("5.1");
    }

    public static boolean isWindowsVista() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("6.0");
    }

    public static boolean isWindows7() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("6.1");
    }

    public static boolean isWindows8() {
        return OS_NAME.indexOf("Windows") > -1 && (OS_VERSION.equals("6.2") || OS_VERSION.equals("6.3"));
    }

    public static boolean isWindows10() {
        return OS_NAME.indexOf("Windows") > -1 && OS_VERSION.equals("10.0");
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("Windows") > -1;
    }

    public static boolean isLinux() {
        return OS_NAME.indexOf("Linux") > -1;
    }

    public static boolean isMacOs() {
        return OS_NAME.indexOf("Mac OS") > -1;
    }

    public static boolean isSolaris() {
        return OS_NAME.indexOf("Solaris") > -1 || OS_NAME.indexOf("SunOS") > -1;
    }

    public static boolean isAix() {
        return OS_NAME.indexOf("AIX") > -1;
    }

    public static boolean isFreeBsd() {
        return OS_NAME.indexOf("FreeBSD") > -1;
    }

    public static boolean isHpUx() {
        return OS_NAME.indexOf("HP-UX") > -1;
    }

    public static boolean isIrix() {
        return OS_NAME.indexOf("Irix") > -1;
    }

    public static boolean isDigitalUnix() {
        return OS_NAME.indexOf("Digital Unix") > -1;
    }

    public static boolean isUnix() {
        return OperatingSystem.isSolaris() || OperatingSystem.isAix() || OperatingSystem.isFreeBsd() || OperatingSystem.isHpUx() || OperatingSystem.isIrix() || OperatingSystem.isDigitalUnix();
    }

    public static boolean isOs2() {
        return OS_NAME.indexOf("OS/2") > -1;
    }

    public static boolean isUnknown() {
        return !OperatingSystem.isWindows() && !OperatingSystem.isLinux() && !OperatingSystem.isMacOs() && !OperatingSystem.isUnix() && !OperatingSystem.isOs2();
    }
}

