/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.MultiRangeReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H$J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/com/intellij/psi/MultiRangeReference;", "expression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canRename", "", "doRenameImplicitConventionalCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "newName", "", "getRange", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getRangeInElement", "getRanges", "", "handleElementRename", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "newElementName", "Companion", "kt-references"})
public abstract class KtInvokeFunctionReference
extends KtSimpleReference<KtCallExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES = CollectionsKt.listOf(OperatorNameConventions.INVOKE);

    public KtInvokeFunctionReference(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super((KtReferenceExpression)expression2);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtCallExpression)this.getElement()).getTextRange().shiftRight(-((KtCallExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "element.textRange.shiftRight(-element.textOffset)");
        return textRange;
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
        KtValueArgumentList valueArgumentList = ((KtCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            List<KtValueArgument> list3 = valueArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list3, "valueArgumentList.arguments");
            if (!((Collection)list3).isEmpty()) {
                ASTNode rPar;
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "valueArgumentList.node");
                ASTNode valueArgumentListNode = aSTNode;
                ASTNode lPar = valueArgumentListNode.findChildByType(KtTokens.LPAR);
                if (lPar != null) {
                    list2.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType(KtTokens.RPAR)) != null) {
                    list2.add(this.getRange(rPar));
                }
            } else {
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "valueArgumentList.node");
                list2.add(this.getRange(aSTNode));
            }
        }
        List<KtLambdaArgument> list4 = ((KtCallExpression)this.getExpression()).getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list4, "expression.lambdaArguments");
        List<KtLambdaArgument> functionLiteralArguments = list4;
        for (KtLambdaArgument functionLiteralArgument : functionLiteralArguments) {
            KtLambdaExpression functionLiteralExpression;
            if (functionLiteralArgument.getLambdaExpression() == null) continue;
            ASTNode aSTNode = functionLiteralExpression.getLeftCurlyBrace();
            Intrinsics.checkNotNullExpressionValue(aSTNode, "functionLiteralExpression.leftCurlyBrace");
            list2.add(this.getRange(aSTNode));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list2.add(this.getRange(rightCurlyBrace));
        }
        return list2;
    }

    private final TextRange getRange(ASTNode node) {
        TextRange textRange = node.getTextRange();
        TextRange textRange2 = textRange.shiftRight(-((KtCallExpression)this.getExpression()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange2, "textRange.shiftRight(-expression.textOffset)");
        return textRange2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter(newElementName, "newElementName");
        KtCallExpression callExpression = (KtCallExpression)this.getExpression();
        KtExpression fullCallExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(callExpression);
        if (Intrinsics.areEqual(newElementName, OperatorNameConventions.GET.asString()) && callExpression.getTypeArguments().isEmpty()) {
            KtExpression arrayAccessExpression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default(callExpression, false, 2, null), false, new Function1<BuilderByPattern<KtExpression>, Unit>(fullCallExpression, callExpression){
                final /* synthetic */ KtExpression $fullCallExpression;
                final /* synthetic */ KtCallExpression $callExpression;
                {
                    this.$fullCallExpression = $fullCallExpression;
                    this.$callExpression = $callExpression;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter($this$buildExpression, "$this$buildExpression");
                    if (this.$fullCallExpression instanceof KtQualifiedExpression) {
                        $this$buildExpression.appendExpression(((KtQualifiedExpression)this.$fullCallExpression).getReceiverExpression());
                        String string2 = ((KtQualifiedExpression)this.$fullCallExpression).getOperationSign().getValue();
                        Intrinsics.checkNotNullExpressionValue(string2, "fullCallExpression.operationSign.value");
                        $this$buildExpression.appendFixedText(string2);
                    }
                    $this$buildExpression.appendExpression(this.$callExpression.getCalleeExpression());
                    $this$buildExpression.appendFixedText("[");
                    List<KtValueArgument> list2 = this.$callExpression.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, "callExpression.valueArguments");
                    Iterable iterable = list2;
                    BuilderByPattern<KtExpression> builderByPattern = $this$buildExpression;
                    boolean $i$f$map = false;
                    void var4_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getArgumentExpression());
                    }
                    BuilderByPattern.appendExpressions$default(builderByPattern, (List)destination$iv$iv, null, 2, null);
                    $this$buildExpression.appendFixedText("]");
                }
            }, 1, null);
            return fullCallExpression.replace(arrayAccessExpression2);
        }
        return this.doRenameImplicitConventionalCall(newElementName);
    }

    @NotNull
    protected abstract KtExpression doRenameImplicitConventionalCall(@Nullable String var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference$Companion;", "", "()V", "NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kt-references"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

