/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Configuration;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanConverter;

final class PlexusConfigurations {
    private final Provider<PlexusBeanConverter> converterProvider;

    PlexusConfigurations(TypeEncounter<?> encounter) {
        this.converterProvider = encounter.getProvider(PlexusBeanConverter.class);
    }

    public <T> Provider<T> lookup(Configuration configuration2, BeanProperty<T> property2) {
        return new ConfigurationProvider<T>(this.converterProvider, property2.getType(), configuration2.value());
    }

    private static final class ConfigurationProvider<T>
    implements Provider<T> {
        private final Provider<PlexusBeanConverter> converterProvider;
        private final TypeLiteral<T> type;
        private final String value;

        ConfigurationProvider(Provider<PlexusBeanConverter> converterProvider, TypeLiteral<T> type2, String value2) {
            this.converterProvider = converterProvider;
            this.type = type2;
            this.value = value2;
        }

        @Override
        public T get() {
            return this.converterProvider.get().convert(this.type, this.value);
        }
    }
}

