/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.LightElementOrigin;
import org.jetbrains.kotlin.asJava.builder.LightElementOriginKt;
import org.jetbrains.kotlin.asJava.builder.MemberIndex;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.fileClasses.OldPackageFacadeClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class StubClassBuilder
extends AbstractClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        @Override
        public Object findInnerClass(String s, Object o) {
            return null;
        }

        @Override
        public void accept(Object innerClass, StubBuildingVisitor<Object> visitor2) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private final PsiJavaFileStub fileStub;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isPackageClass;
    private int memberIndex;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack, @NotNull PsiJavaFileStub fileStub) {
        if (parentStack == null) {
            StubClassBuilder.$$$reportNull$$$0(0);
        }
        if (fileStub == null) {
            StubClassBuilder.$$$reportNull$$$0(1);
        }
        this.isPackageClass = false;
        this.memberIndex = 0;
        this.parentStack = parentStack;
        this.parent = parentStack.peek();
        this.fileStub = fileStub;
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        StubBuildingVisitor stubBuildingVisitor = this.v;
        if (stubBuildingVisitor == null) {
            StubClassBuilder.$$$reportNull$$$0(2);
        }
        return stubBuildingVisitor;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name2, @Nullable String signature2, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        if (name2 == null) {
            StubClassBuilder.$$$reportNull$$$0(3);
        }
        if (superName == null) {
            StubClassBuilder.$$$reportNull$$$0(4);
        }
        if (interfaces == null) {
            StubClassBuilder.$$$reportNull$$$0(5);
        }
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor<Object>(null, EMPTY_STRATEGY, this.parent, access, this.calculateShortName(name2));
        super.defineClass(origin, version, access, name2, signature2, superName, interfaces);
        if (origin instanceof KtFile && (name2.equals(packageClassName = OldPackageFacadeClassUtils.getPackageClassName(packageName = ((KtFile)origin).getPackageFqName())) || name2.endsWith("/" + packageClassName))) {
            this.isPackageClass = true;
        }
        if (!this.isPackageClass) {
            this.parentStack.push(this.v.getResult());
        }
        ((StubBase)((Object)this.v.getResult())).putUserData(ClsWrapperStubPsiFactory.ORIGIN, LightElementOriginKt.toLightClassOrigin(origin));
    }

    @Nullable
    private String calculateShortName(@NotNull String internalName2) {
        if (internalName2 == null) {
            StubClassBuilder.$$$reportNull$$$0(6);
        }
        if (this.parent instanceof PsiJavaFileStub) {
            assert (this.parent == this.fileStub);
            String packagePrefix = this.getPackageInternalNamePrefix();
            assert (internalName2.startsWith(packagePrefix)) : internalName2 + " : " + packagePrefix;
            return internalName2.substring(packagePrefix.length());
        }
        if (this.parent instanceof PsiClassStub) {
            String parentPrefix = this.getClassInternalNamePrefix((PsiClassStub)this.parent);
            if (parentPrefix == null) {
                return null;
            }
            assert (internalName2.startsWith(parentPrefix)) : internalName2 + " : " + parentPrefix;
            return internalName2.substring(parentPrefix.length());
        }
        return null;
    }

    @Nullable
    private String getClassInternalNamePrefix(@NotNull PsiClassStub classStub) {
        if (classStub == null) {
            StubClassBuilder.$$$reportNull$$$0(7);
        }
        String packageName = this.fileStub.getPackageName();
        String classStubQualifiedName = classStub.getQualifiedName();
        if (classStubQualifiedName == null) {
            return null;
        }
        if (packageName.isEmpty()) {
            return classStubQualifiedName.replace('.', '$') + "$";
        }
        return packageName.replace('.', '/') + "/" + classStubQualifiedName.substring(packageName.length() + 1).replace('.', '$') + "$";
    }

    @NotNull
    private String getPackageInternalNamePrefix() {
        String packageName = this.fileStub.getPackageName();
        if (packageName.isEmpty()) {
            return "";
        }
        String string2 = packageName.replace('.', '/') + "/";
        if (string2 == null) {
            StubClassBuilder.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        MethodVisitor internalVisitor;
        if (origin == null) {
            StubClassBuilder.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            StubClassBuilder.$$$reportNull$$$0(10);
        }
        if (desc == null) {
            StubClassBuilder.$$$reportNull$$$0(11);
        }
        if ((internalVisitor = super.newMethod(origin, access, name2, desc, signature2, exceptions)) != EMPTY_METHOD_VISITOR) {
            this.markLastChild(origin);
        }
        MethodVisitor methodVisitor = internalVisitor;
        if (methodVisitor == null) {
            StubClassBuilder.$$$reportNull$$$0(12);
        }
        return methodVisitor;
    }

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable Object value2) {
        FieldVisitor internalVisitor;
        if (origin == null) {
            StubClassBuilder.$$$reportNull$$$0(13);
        }
        if (name2 == null) {
            StubClassBuilder.$$$reportNull$$$0(14);
        }
        if (desc == null) {
            StubClassBuilder.$$$reportNull$$$0(15);
        }
        if ((internalVisitor = super.newField(origin, access, name2, desc, signature2, value2)) != EMPTY_FIELD_VISITOR) {
            this.markLastChild(origin);
        }
        FieldVisitor fieldVisitor = internalVisitor;
        if (fieldVisitor == null) {
            StubClassBuilder.$$$reportNull$$$0(16);
        }
        return fieldVisitor;
    }

    private void markLastChild(@NotNull JvmDeclarationOrigin origin) {
        List<StubElement> children2;
        StubBase last2;
        LightElementOrigin oldOrigin;
        if (origin == null) {
            StubClassBuilder.$$$reportNull$$$0(17);
        }
        if ((oldOrigin = (last2 = (StubBase)(children2 = this.v.getResult().getChildrenStubs()).get(children2.size() - 1)).getUserData(ClsWrapperStubPsiFactory.ORIGIN)) != null) {
            PsiElement originalElement2 = oldOrigin.getOriginalElement();
            throw new IllegalStateException("Rewriting origin element: " + (originalElement2 != null ? originalElement2.getText() : null) + " for stub " + last2.toString());
        }
        last2.putUserData(ClsWrapperStubPsiFactory.ORIGIN, LightElementOriginKt.toLightMemberOrigin(origin));
        last2.putUserData(MemberIndex.KEY, new MemberIndex(this.memberIndex++));
    }

    @Override
    public void done() {
        if (!this.isPackageClass) {
            StubElement pop2 = this.parentStack.pop();
            assert (pop2 == this.v.getResult()) : "parentStack: got " + pop2 + ", expected " + this.v.getResult();
        }
        super.done();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStub";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/asJava/builder/StubClassBuilder";
                break;
            }
            case 3: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classStub";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/asJava/builder/StubClassBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageInternalNamePrefix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newMethod";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "defineClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateShortName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassInternalNamePrefix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newField";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markLastChild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

