/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinValue;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"checkSinceKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinAccessibility;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getOwnSinceKotlinVersion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "loadWasExperimentalMarkerClasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirSinceKotlinHelpersKt {
    @NotNull
    public static final FirSinceKotlinAccessibility checkSinceKotlinVersionAccessibility(@NotNull FirDeclaration $this$checkSinceKotlinVersionAccessibility, @NotNull CheckerContext context) {
        FirSinceKotlinValue value2;
        Intrinsics.checkNotNullParameter($this$checkSinceKotlinVersionAccessibility, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        FirSinceKotlinValue firSinceKotlinValue = value2 = FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion($this$checkSinceKotlinVersionAccessibility, context.getSession());
        ApiVersion version = firSinceKotlinValue != null ? firSinceKotlinValue.getApiVersion() : null;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        if (version == null || version.compareTo(languageVersionSettings.getApiVersion()) <= 0) {
            return FirSinceKotlinAccessibility.Accessible.INSTANCE;
        }
        List<FirRegularClassSymbol> wasExperimentalFqNames = value2.getWasExperimentalMarkerClasses();
        if (!((Collection)wasExperimentalFqNames).isEmpty()) {
            return new FirSinceKotlinAccessibility.NotAccessibleButWasExperimental(version, wasExperimentalFqNames);
        }
        return new FirSinceKotlinAccessibility.NotAccessible(version);
    }

    private static final FirSinceKotlinValue getOwnSinceKotlinVersion(FirDeclaration $this$getOwnSinceKotlinVersion, FirSession session2) {
        Ref.ObjectRef<FirSinceKotlinValue> result2;
        block2: {
            ConeKotlinType coneKotlinType;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId classId;
            result2 = new Ref.ObjectRef<FirSinceKotlinValue>();
            FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider($this$getOwnSinceKotlinVersion, result2);
            if ($this$getOwnSinceKotlinVersion instanceof FirConstructor && (classId = ((FirConstructor)$this$getOwnSinceKotlinVersion).getSymbol().getCallableId().getClassId()) != null) {
                FirClassLikeSymbol<?> classSymbol;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = classSymbol = FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(classId);
                if (firClassLikeSymbol2 != null) {
                    FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider-0(firClassLikeSymbol2, result2);
                }
            }
            if (!($this$getOwnSinceKotlinVersion instanceof FirTypeAlias) || (firClassLikeSymbol = (coneKotlinType = FirTypeUtilsKt.getConeType(((FirTypeAlias)$this$getOwnSinceKotlinVersion).getExpandedTypeRef())) instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) == null || (firClassLikeSymbol = ((ConeClassLikeType)((Object)firClassLikeSymbol)).getLookupTag()) == null || (firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)((Object)firClassLikeSymbol), session2)) == null) break block2;
            FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider-0(firClassLikeSymbol, result2);
        }
        return (FirSinceKotlinValue)result2.element;
    }

    private static final List<FirRegularClassSymbol> loadWasExperimentalMarkerClasses(FirDeclaration $this$loadWasExperimentalMarkerClasses) {
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$loadWasExperimentalMarkerClasses, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID());
        if (firAnnotation == null) {
            return CollectionsKt.emptyList();
        }
        FirAnnotation wasExperimental = firAnnotation;
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(wasExperimental, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS());
        if (firExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        FirExpression annotationClasses = firExpression2;
        return FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses);
    }

    private static final void getOwnSinceKotlinVersion$consider(FirDeclaration $this$getOwnSinceKotlinVersion_u24consider, Ref.ObjectRef<FirSinceKotlinValue> result2) {
        block5: {
            ApiVersion apiVersion;
            block6: {
                ApiVersion apiVersion2;
                FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getOwnSinceKotlinVersion_u24consider, StandardClassIds.Annotations.INSTANCE.getSinceKotlin());
                FirExpression sinceKotlinSingleArgument = firAnnotation != null ? FirAnnotationUtilsKt.findArgumentByName(firAnnotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getSinceKotlinVersion()) : null;
                FirConstExpression firConstExpression = sinceKotlinSingleArgument instanceof FirConstExpression ? (FirConstExpression)sinceKotlinSingleArgument : null;
                Object object = firConstExpression != null ? firConstExpression.getValue() : null;
                String string2 = object instanceof String ? (String)object : null;
                if (string2 != null) {
                    object = string2;
                    ApiVersion.Companion companion = ApiVersion.Companion;
                    Object p0 = object;
                    boolean bl = false;
                    apiVersion2 = companion.parse((String)p0);
                } else {
                    apiVersion2 = apiVersion = null;
                }
                if (apiVersion == null) break block5;
                if (result2.element == null) break block6;
                Object t = result2.element;
                Intrinsics.checkNotNull(t);
                if (apiVersion.compareTo(((FirSinceKotlinValue)t).getApiVersion()) <= 0) break block5;
            }
            result2.element = new FirSinceKotlinValue(apiVersion, FirSinceKotlinHelpersKt.loadWasExperimentalMarkerClasses($this$getOwnSinceKotlinVersion_u24consider));
        }
    }

    private static final void getOwnSinceKotlinVersion$consider-0(FirClassLikeSymbol<?> $this$getOwnSinceKotlinVersion_u24consider_u2d0, Ref.ObjectRef<FirSinceKotlinValue> result2) {
        FirPhaseManagerKt.ensureResolved((FirBasedSymbol)$this$getOwnSinceKotlinVersion_u24consider_u2d0, FirResolvePhase.BODY_RESOLVE);
        FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider($this$getOwnSinceKotlinVersion_u24consider_u2d0.getFir(), result2);
    }
}

