/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jetbrains.kotlin.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;

@Singleton
@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private float priority = 10.0f;
    private TrackingFileManager trackingFileManager;

    @Override
    public void initService(ServiceLocator locator) {
        TrackingFileManager trackingFileManager = locator.getService(TrackingFileManager.class);
        trackingFileManager.getClass();
        this.trackingFileManager = trackingFileManager;
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session2, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), session2, this.trackingFileManager);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }
}

