/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.cli;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.cli.FlagAction;
import kotlinx.cli.HelpEntry;
import kotlinx.cli.HelpPrinter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/cli/FlagActionBase;", "Lkotlinx/cli/FlagAction;", "Lkotlinx/cli/HelpEntry;", "flags", "", "", "help", "(Ljava/util/List;Ljava/lang/String;)V", "getFlags", "()Ljava/util/List;", "syntax", "printHelp", "", "helpPrinter", "Lkotlinx/cli/HelpPrinter;", "ki-shell"})
public abstract class FlagActionBase
implements FlagAction,
HelpEntry {
    @NotNull
    private final List<String> flags;
    @NotNull
    private final String help;
    @NotNull
    private final String syntax;

    public FlagActionBase(@NotNull List<String> flags, @NotNull String help2) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        Intrinsics.checkNotNullParameter(help2, "help");
        this.flags = flags;
        this.help = help2;
        if (this.flags.isEmpty()) {
            throw new IllegalStateException("At least one flag required".toString());
        }
        this.syntax = CollectionsKt.joinToString$default(this.flags, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final List<String> getFlags() {
        return this.flags;
    }

    @Override
    public void printHelp(@NotNull HelpPrinter helpPrinter) {
        Intrinsics.checkNotNullParameter(helpPrinter, "helpPrinter");
        helpPrinter.printEntry(this.syntax, this.help);
    }

    @Override
    public void invoke(@NotNull ListIterator<String> arguments2) {
        FlagAction.DefaultImpls.invoke(this, arguments2);
    }
}

