/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.spi;

import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.MembersInjector;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.ElementVisitor;

public final class MembersInjectorLookup<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private MembersInjector<T> delegate;

    public MembersInjectorLookup(Object source, TypeLiteral<T> type2) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.type = Preconditions.checkNotNull(type2, "type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor2) {
        return visitor2.visit(this);
    }

    public void initializeDelegate(MembersInjector<T> delegate2) {
        Preconditions.checkState(this.delegate == null, "delegate already initialized");
        this.delegate = Preconditions.checkNotNull(delegate2, "delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getMembersInjector(this.type));
    }

    public MembersInjector<T> getDelegate() {
        return this.delegate;
    }

    public MembersInjector<T> getMembersInjector() {
        return new MembersInjector<T>(){

            @Override
            public void injectMembers(T instance) {
                MembersInjector local = MembersInjectorLookup.this.delegate;
                if (local == null) {
                    throw new IllegalStateException("This MembersInjector cannot be used until the Injector has been created.");
                }
                local.injectMembers(instance);
            }

            public String toString() {
                return "MembersInjector<" + MembersInjectorLookup.this.type + ">";
            }
        };
    }
}

